/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.enchanter;

import com.lothrazar.cyclicmagic.block.enchanter.EnchanterTESR;
import com.lothrazar.cyclicmagic.block.enchanter.TileEntityEnchanter;
import com.lothrazar.cyclicmagic.config.IHasConfig;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.core.block.IBlockHasTESR;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnchanter
extends BlockBaseHasTile
implements IHasRecipe,
IBlockHasTESR,
IHasConfig {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    public static int FUEL_COST = 0;

    public BlockEnchanter() {
        super(Material.field_151576_e);
        super.setGuiId(30);
        this.func_149711_c(3.0f).func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setTranslucent();
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityEnchanter();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnchanter.class, (TileEntitySpecialRenderer)new EnchanterTESR(0));
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), " b ", "eoe", "ooo", Character.valueOf('b'), Blocks.field_150381_bn, Character.valueOf('e'), "gemEmerald", Character.valueOf('o'), "obsidian");
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityEnchanter te = (TileEntityEnchanter)world.func_175625_s(pos);
        boolean success = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
        if (te != null && !world.field_72995_K) {
            int currentFluid = te.getCurrentFluidStackAmount();
            UtilChat.sendStatusMessage(player, UtilChat.lang("cyclic.fluid.amount") + currentFluid);
        }
        return success || FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null || super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public void syncConfig(Configuration config) {
        FUEL_COST = config.getInt(this.getRawName(), "cyclicmagic.FuelCost", 900, 0, 500000, "Fuel/Energy/RF cost to run machine");
        TileEntityEnchanter.FLUID_COST = config.getInt(this.getRawName() + "_xpjuice", "cyclicmagic.FuelCost", 100, 1, 1000, "Experience fluid cost per damage unit");
    }
}

