/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.crafter;

import com.lothrazar.cyclicmagic.block.crafter.BlockCrafter;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.core.util.UtilInventoryTransfer;
import com.lothrazar.cyclicmagic.core.util.UtilItemStack;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityCrafter
extends TileEntityBaseMachineInvo
implements ITileRedstoneToggle,
ITickable {
    public static final int TIMER_FULL = 20;
    public static final int ROWS = 5;
    public static final int COLS = 2;
    public static final int SIZE_INPUT = 10;
    public static final int SIZE_GRID = 9;
    public static final int SIZE_OUTPUT = 10;
    private Container fakeContainer = new Container(){

        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            return false;
        }
    };
    private IRecipe recipe;
    private int needsRedstone = 1;
    private InventoryCrafting crafter = new InventoryCrafting(this.fakeContainer, 3, 3);

    public TileEntityCrafter() {
        super(29);
        this.initEnergy(BlockCrafter.FUEL_COST);
        this.setSlotsForInsert(0, 9);
        this.setSlotsForExtract(19, 28);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        this.spawnParticlesAbove();
        if (!this.updateTimerIsZero()) {
            return;
        }
        if (this.getEnergyCurrent() >= this.getEnergyCost()) {
            this.findRecipe();
            if (this.recipe != null && this.tryPayCost()) {
                ItemStack craftingResult = this.recipe.func_77572_b(this.crafter);
                this.sendOutput(craftingResult);
                this.timer = 20;
                this.consumeEnergy();
            }
        }
    }

    private boolean tryPayCost() {
        boolean thisPaid = false;
        HashMap<Integer, Integer> slotsToPay = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.crafter.func_70302_i_(); ++i) {
            thisPaid = false;
            ItemStack fromRecipe = this.crafter.func_70301_a(i);
            if (fromRecipe.func_190926_b()) continue;
            for (int j = 0; j < 10; ++j) {
                ItemStack fromInput = this.func_70301_a(j);
                if (!fromRecipe.func_77969_a(fromInput)) continue;
                if (!slotsToPay.containsKey(j)) {
                    slotsToPay.put(j, 0);
                }
                if ((Integer)slotsToPay.get(j) + 1 > fromInput.func_190916_E()) continue;
                slotsToPay.put(j, (Integer)slotsToPay.get(j) + 1);
                thisPaid = true;
                break;
            }
            if (thisPaid) continue;
            return false;
        }
        for (Map.Entry entry : slotsToPay.entrySet()) {
            if ((Integer)entry.getValue() <= this.func_70301_a((Integer)entry.getKey()).func_190916_E()) continue;
            return false;
        }
        for (Map.Entry entry : slotsToPay.entrySet()) {
            Item bucketThing = this.func_70301_a((Integer)entry.getKey()).func_77973_b().func_77668_q();
            if (bucketThing != null && this.func_70301_a((Integer)entry.getKey()).func_190916_E() == 1) {
                this.sendOutput(new ItemStack(bucketThing));
            }
            this.func_70301_a((Integer)entry.getKey()).func_190918_g(((Integer)entry.getValue()).intValue());
        }
        return true;
    }

    private void sendOutput(ItemStack craftingResult) {
        ArrayList<ItemStack> toDrop = UtilInventoryTransfer.dumpToIInventory(Arrays.asList(craftingResult), this, 19);
        if (!toDrop.isEmpty()) {
            for (ItemStack s : toDrop) {
                UtilItemStack.dropItemStackInWorld(this.func_145831_w(), this.func_174877_v().func_177984_a(), s);
            }
        }
    }

    private void findRecipe() {
        this.setRecipeInput();
        if (this.recipe != null && this.recipe.func_77569_a(this.crafter, this.field_145850_b)) {
            return;
        }
        this.recipe = null;
        for (IRecipe rec : CraftingManager.field_193380_a) {
            try {
                if (!rec.func_77569_a(this.crafter, this.field_145850_b)) continue;
                this.recipe = rec;
                return;
            }
            catch (Exception err) {
                throw new RuntimeException("Caught exception while querying recipe ", err);
            }
        }
    }

    private void setRecipeInput() {
        int gridStart;
        for (int i = gridStart = 10; i < gridStart + 9; ++i) {
            int craftSlot = i - gridStart;
            this.crafter.func_70299_a(craftSlot, this.func_70301_a(i));
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void toggleNeedsRedstone() {
        this.func_174885_b(Fields.REDSTONE.ordinal(), (this.needsRedstone + 1) % 2);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needsRedstone = compound.func_74762_e("redstone");
        this.timer = compound.func_74762_e("Timer");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("Timer", this.timer);
        compound.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(compound);
    }

    public static enum Fields {
        REDSTONE,
        TIMER;

    }
}

