/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.conveyor;

import com.google.common.base.Predicate;
import com.lothrazar.cyclicmagic.block.conveyor.BlockConveyorAngle;
import com.lothrazar.cyclicmagic.block.conveyor.BlockConveyorCorner;
import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBaseFlat;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockConveyor
extends BlockBaseFlat
implements IHasRecipe {
    protected static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final int RECIPE_OUTPUT = 8;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final float ANGLE = 1.0f;
    private static final float powerCorrection = 0.02f;
    protected SpeedType type;
    protected float power;
    private SoundEvent sound;
    public static boolean doCorrections = true;
    protected boolean keepEntityGrounded = true;
    private BlockConveyor corner;
    private BlockConveyor angled;
    protected BlockConveyor dropFlat = this;
    public static boolean sneakPlayerAvoid;

    public BlockConveyor(SpeedType t) {
        super(Material.field_151576_e);
        this.type = t;
        switch (this.type) {
            case LARGE: {
                this.power = 0.32f;
                break;
            }
            case MEDIUM: {
                this.power = 0.2f;
                break;
            }
            case SMALL: {
                this.power = 0.16f;
                break;
            }
            case TINY: {
                this.power = 0.08f;
                break;
            }
        }
    }

    public BlockConveyor(@Nonnull BlockConveyor corner, @Nonnull BlockConveyor angled) {
        this(corner.type);
        this.setCorner(corner);
        this.setAngled(angled);
        this.func_149672_a(SoundType.field_185852_e);
        this.sound = SoundEvents.field_187677_b;
    }

    public boolean isAngle() {
        return false;
    }

    public boolean isCorner() {
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing iAmFacing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        if (this.isAngle()) {
            if (iAmFacing == EnumFacing.NORTH) {
                if (((Boolean)state.func_177229_b((IProperty)BlockConveyorAngle.FLIPPED)).booleanValue()) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)BlockConveyorAngle.FLIPPED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.EAST));
                } else {
                    world.func_175656_a(pos, this.dropFlat.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.EAST));
                }
                return true;
            }
        } else if (this.isCorner()) {
            if (iAmFacing == EnumFacing.NORTH) {
                if (((Boolean)state.func_177229_b((IProperty)BlockConveyorCorner.FLIPPED)).booleanValue()) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.EAST));
                } else {
                    world.func_175656_a(pos, this.getAngled().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.EAST));
                }
                return true;
            }
        } else if (iAmFacing == EnumFacing.NORTH) {
            world.func_175656_a(pos, this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.EAST));
            return true;
        }
        return super.rotateBlock(world, pos, axis);
    }

    protected void playClickOnSound(World worldIn, BlockPos pos) {
        worldIn.func_184133_a((EntityPlayer)null, pos, this.sound, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (sneakPlayerAvoid && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af()) {
            return;
        }
        EnumFacing face = this.getFacingFromState(state);
        this.tickMovement(pos, entity, face);
        if (!(entity instanceof EntityLivingBase)) {
            entity.field_70181_x += 0.5;
            this.hackOverBump(worldIn, pos, entity, face);
        }
    }

    protected void hackOverBump(World worldIn, BlockPos pos, Entity entity, EnumFacing face) {
        if (!(entity instanceof EntityLivingBase) && worldIn.func_180495_p(pos.func_177972_a(face)).func_177230_c() instanceof BlockConveyorAngle || worldIn.func_180495_p(pos.func_177972_a(face).func_177984_a()).func_177230_c() instanceof BlockConveyorAngle) {
            entity.field_70122_E = false;
            entity.field_70181_x += 0.1;
        }
    }

    protected void tickMovement(BlockPos pos, Entity entity, EnumFacing face) {
        entity.field_70122_E = true;
        UtilEntity.launchDirection(entity, this.power, face);
        if (doCorrections) {
            double diff;
            if (face == EnumFacing.NORTH || face == EnumFacing.SOUTH) {
                double xDiff = (double)pos.func_177958_n() + 0.5 - entity.field_70165_t;
                if (Math.abs(xDiff) > 0.09) {
                    if (xDiff < 0.0) {
                        UtilEntity.launchDirection(entity, 0.02f, EnumFacing.WEST);
                    } else {
                        UtilEntity.launchDirection(entity, 0.02f, EnumFacing.EAST);
                    }
                }
            } else if ((face == EnumFacing.EAST || face == EnumFacing.WEST) && Math.abs(diff = (double)pos.func_177952_p() + 0.5 - entity.field_70161_v) > 0.09) {
                if (diff < 0.0) {
                    UtilEntity.launchDirection(entity, 0.02f, EnumFacing.NORTH);
                } else {
                    UtilEntity.launchDirection(entity, 0.02f, EnumFacing.SOUTH);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        int speed = (int)(this.power * 100.0f);
        tooltip.add(UtilChat.lang("tile.plate_push.tooltip") + speed);
    }

    @Override
    public IRecipe addRecipe() {
        switch (this.type) {
            case LARGE: {
                RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 8), "sbs", "bxb", "sbs", Character.valueOf('s'), "ingotIron", Character.valueOf('x'), Items.field_151119_aD, Character.valueOf('b'), "dyeRed");
                break;
            }
            case MEDIUM: {
                RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 8), "sbs", "bxb", "sbs", Character.valueOf('s'), "ingotIron", Character.valueOf('x'), Items.field_151119_aD, Character.valueOf('b'), "dyePurple");
                break;
            }
            case SMALL: {
                RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 8), "sbs", "bxb", "sbs", Character.valueOf('s'), "ingotIron", Character.valueOf('x'), Items.field_151119_aD, Character.valueOf('b'), "dyeMagenta");
                break;
            }
            case TINY: {
                RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 8), "sbs", "bxb", "sbs", Character.valueOf('s'), "ingotIron", Character.valueOf('x'), Items.field_151119_aD, Character.valueOf('b'), "dyeLightBlue");
                break;
            }
        }
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing);
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        int facingbits = facing.func_176736_b();
        return facingbits;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer.func_70093_af()) {
            return;
        }
        IBlockState north = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        IBlockState south = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        IBlockState west = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        IBlockState east = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        boolean isNorth = north.func_177230_c() instanceof BlockConveyor;
        boolean isSouth = south.func_177230_c() instanceof BlockConveyor;
        boolean isWest = west.func_177230_c() instanceof BlockConveyor;
        boolean isEast = east.func_177230_c() instanceof BlockConveyor;
        IBlockState northUp = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH).func_177984_a());
        IBlockState southUp = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH).func_177984_a());
        IBlockState westUp = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST).func_177984_a());
        IBlockState eastUp = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST).func_177984_a());
        boolean isNorthUp = northUp.func_177230_c() instanceof BlockConveyor;
        boolean isSouthUp = southUp.func_177230_c() instanceof BlockConveyor;
        boolean isWestUp = westUp.func_177230_c() instanceof BlockConveyor;
        boolean isEastUp = eastUp.func_177230_c() instanceof BlockConveyor;
        BlockPos posTarget = new BlockPos((Vec3i)pos);
        IBlockState targetState = null;
        boolean flip = false;
        if (isEastUp) {
            boolean bl = flip = eastUp.func_177229_b((IProperty)PROPERTYFACING) == EnumFacing.WEST;
            if (eastUp.func_177230_c() instanceof BlockConveyorAngle) {
                flip = flip || (Boolean)eastUp.func_177229_b((IProperty)BlockConveyorAngle.FLIPPED) != false;
            }
            targetState = this.getAngled().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockConveyorAngle.FLIPPED, (Comparable)Boolean.valueOf(flip));
        } else if (isWestUp) {
            boolean bl = flip = westUp.func_177229_b((IProperty)PROPERTYFACING) == EnumFacing.EAST;
            if (westUp.func_177230_c() instanceof BlockConveyorAngle) {
                flip = flip || (Boolean)westUp.func_177229_b((IProperty)BlockConveyorAngle.FLIPPED) != false;
            }
            targetState = this.getAngled().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockConveyorAngle.FLIPPED, (Comparable)Boolean.valueOf(flip));
        } else if (isSouthUp) {
            boolean bl = flip = southUp.func_177229_b((IProperty)PROPERTYFACING) == EnumFacing.NORTH;
            if (southUp.func_177230_c() instanceof BlockConveyorAngle) {
                flip = flip || (Boolean)southUp.func_177229_b((IProperty)BlockConveyorAngle.FLIPPED) != false;
            }
            targetState = this.getAngled().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockConveyorAngle.FLIPPED, (Comparable)Boolean.valueOf(flip));
        } else if (isNorthUp) {
            if (northUp.func_177230_c() instanceof BlockConveyorAngle) {
                flip = flip || (Boolean)northUp.func_177229_b((IProperty)BlockConveyorAngle.FLIPPED) != false;
            }
            flip = northUp.func_177229_b((IProperty)PROPERTYFACING) == EnumFacing.SOUTH;
            targetState = this.getAngled().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockConveyorAngle.FLIPPED, (Comparable)Boolean.valueOf(flip));
        } else if (isNorth && isWest) {
            targetState = west.func_177229_b((IProperty)PROPERTYFACING) == EnumFacing.EAST ? this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, west.func_177229_b((IProperty)PROPERTYFACING)).func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(true)) : this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, north.func_177229_b((IProperty)PROPERTYFACING)).func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(false));
        } else if (isNorth && isEast) {
            targetState = east.func_177229_b((IProperty)PROPERTYFACING) == EnumFacing.WEST ? this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, east.func_177229_b((IProperty)PROPERTYFACING)).func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(false)) : this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, north.func_177229_b((IProperty)PROPERTYFACING)).func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(true));
        } else if (isSouth && isEast) {
            targetState = south.func_177229_b((IProperty)PROPERTYFACING) == EnumFacing.NORTH ? this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, south.func_177229_b((IProperty)PROPERTYFACING)).func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(false)) : this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, east.func_177229_b((IProperty)PROPERTYFACING)).func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(true));
        } else if (isSouth && isWest) {
            targetState = west.func_177229_b((IProperty)PROPERTYFACING) == EnumFacing.WEST ? this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, south.func_177229_b((IProperty)PROPERTYFACING)).func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(true)) : this.getCorner().func_176223_P().func_177226_a((IProperty)PROPERTYFACING, west.func_177229_b((IProperty)PROPERTYFACING)).func_177226_a((IProperty)BlockConveyorCorner.FLIPPED, (Comparable)Boolean.valueOf(false));
        } else if (isSouth) {
            targetState = this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)this.getFacingDir(south));
        } else if (isNorth) {
            targetState = this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)this.getFacingDir(north));
        } else if (isWest) {
            targetState = this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)this.getFacingDir(west));
        } else if (isEast) {
            targetState = this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)this.getFacingDir(east));
        }
        if (targetState != null) {
            world.func_175656_a(posTarget, targetState);
        }
    }

    private EnumFacing getFacingDir(IBlockState st) {
        EnumFacing f = (EnumFacing)st.func_177229_b((IProperty)PROPERTYFACING);
        if (st.func_177230_c() instanceof BlockConveyorAngle && ((Boolean)st.func_177229_b((IProperty)BlockConveyorAngle.FLIPPED)).booleanValue()) {
            f = f.func_176734_d();
        }
        return f;
    }

    public BlockConveyor getCorner() {
        return this.corner;
    }

    public void setCorner(BlockConveyor corner) {
        this.corner = corner;
    }

    public BlockConveyor getAngled() {
        return this.angled;
    }

    public void setAngled(BlockConveyor angled) {
        this.angled = angled;
    }

    public static enum SpeedType {
        TINY,
        SMALL,
        MEDIUM,
        LARGE;

    }
}

