/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.anvilmagma;

import com.lothrazar.cyclicmagic.block.anvil.TileEntityAnvilAuto;
import com.lothrazar.cyclicmagic.core.block.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.core.liquid.FluidTankBase;
import com.lothrazar.cyclicmagic.core.util.UtilString;
import com.lothrazar.cyclicmagic.gui.ITileRedstoneToggle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityAnvilMagma
extends TileEntityBaseMachineFluid
implements ITickable,
ITileRedstoneToggle {
    public static final int TANK_FULL = 10000;
    public static final int TIMER_FULL = 5;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static int FLUID_COST = 75;
    private int timer = 0;
    private int needsRedstone = 0;

    public TileEntityAnvilMagma() {
        super(2);
        this.tank = new FluidTankBase(10000);
        this.tank.setFluidAllowed(FluidRegistry.LAVA);
        this.setSlotsForExtract(1);
        this.setSlotsForInsert(0);
    }

    private boolean isBlockAllowed(ItemStack thing) {
        return !UtilString.isInList(TileEntityAnvilAuto.blacklistBlockIds, thing.func_77973_b().getRegistryName());
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        ItemStack inputStack = this.func_70301_a(0);
        if (!inputStack.func_77951_h() || !this.isBlockAllowed(inputStack)) {
            if (this.func_70301_a(1).func_190926_b()) {
                this.func_70299_a(1, this.func_70304_b(0));
            }
            return;
        }
        if (inputStack.func_190926_b() || !this.hasEnoughFluid()) {
            return;
        }
        this.spawnParticlesAbove();
        if (this.getCurrentFluidStackAmount() < 0) {
            this.setCurrentFluid(0);
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 5;
            if (inputStack.func_77951_h() && this.hasEnoughFluid()) {
                inputStack.func_77964_b(inputStack.func_77952_i() - 1);
                this.drain(FLUID_COST, true);
            }
        }
    }

    private boolean hasEnoughFluid() {
        FluidStack contains = this.tank.getFluid();
        return contains != null && contains.amount >= FLUID_COST;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a("Timer", this.timer);
        tags.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e("Timer");
        this.needsRedstone = tags.func_74762_e("redstone");
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        this.func_174885_b(Fields.REDSTONE.ordinal(), (this.needsRedstone + 1) % 2);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE;

    }
}

