/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block;

import com.lothrazar.cyclicmagic.core.IHasRecipe;
import com.lothrazar.cyclicmagic.core.block.BlockBaseFlat;
import com.lothrazar.cyclicmagic.core.util.UtilChat;
import com.lothrazar.cyclicmagic.core.util.UtilEntity;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLaunch
extends BlockBaseFlat
implements IHasRecipe {
    private static final float ANGLE = 90.0f;
    private static final int RECIPE_OUT = 6;
    public static boolean sneakPlayerAvoid;
    private LaunchType type;
    private float power;
    private SoundEvent sound;

    public BlockLaunch(LaunchType t, SoundEvent s) {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185859_l);
        this.sound = s;
        this.type = t;
        switch (this.type) {
            case LARGE: {
                this.power = 1.8f;
                break;
            }
            case MEDIUM: {
                this.power = 1.3f;
                break;
            }
            case SMALL: {
                this.power = 0.8f;
                break;
            }
        }
    }

    protected void playClickOnSound(World worldIn, BlockPos pos) {
        worldIn.func_184133_a((EntityPlayer)null, pos, this.sound, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (sneakPlayerAvoid && entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af()) {
            return;
        }
        UtilEntity.launch(entity, 90.0f, this.power);
        this.playClickOnSound(worldIn, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        int fakePower = Math.round(this.power * 10.0f);
        tooltip.add(UtilChat.lang("tile.plate_launch.tooltip" + fakePower));
    }

    @Override
    public IRecipe addRecipe() {
        switch (this.type) {
            case LARGE: {
                RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 6), "sss", "ggg", "iii", Character.valueOf('s'), "slimeball", Character.valueOf('g'), Blocks.field_150456_au, Character.valueOf('i'), Blocks.field_150443_bT);
                break;
            }
            case MEDIUM: {
                RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 6), "sss", "ggg", "iii", Character.valueOf('s'), "slimeball", Character.valueOf('g'), Blocks.field_150452_aw, Character.valueOf('i'), Blocks.field_150443_bT);
                break;
            }
            case SMALL: {
                RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 6), "sss", "ggg", "iii", Character.valueOf('s'), "slimeball", Character.valueOf('g'), Blocks.field_150445_bS, Character.valueOf('i'), Blocks.field_150443_bT);
            }
        }
        return null;
    }

    public static enum LaunchType {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

