/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper.obfuscation;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.cyclops.cyclopscore.helper.obfuscation.ObfuscationData;

public class ObfuscationHelpers {
    public static void setPotionTypesArray(Potion[] potionTypes) {
        Field field = ReflectionHelper.findField(Potion.class, (String[])ObfuscationData.POTION_POTIONTYPES);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            field.set(null, potionTypes);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public static int getShapedOreRecipeWidth(ShapedOreRecipe recipe) {
        return (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)recipe, (String[])ObfuscationData.SHAPEDORERECIPE_WIDTH);
    }

    public static int getShapedOreRecipeHeight(ShapedOreRecipe recipe) {
        return (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)recipe, (String[])ObfuscationData.SHAPEDORERECIPE_HEIGHT);
    }

    public static List<LootPool> getLootPools(LootTable lootTable) {
        return (List)ReflectionHelper.getPrivateValue(LootTable.class, (Object)lootTable, (String[])ObfuscationData.LOOTTABLE_POOLS);
    }

    public static ResourceLocation getParticleTexture() {
        return (ResourceLocation)ReflectionHelper.getPrivateValue(ParticleManager.class, null, (String[])ObfuscationData.PARTICLE_TEXTURES);
    }

    public static CapabilityDispatcher getEntityCapabilities(Entity entity) {
        Field field = ReflectionHelper.findField(Entity.class, (String[])ObfuscationData.ENTITY_CAPABILITIES);
        try {
            return (CapabilityDispatcher)field.get(entity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends ICriterionTrigger<?>> T registerCriteriaTrigger(T criterion) {
        Method method = ReflectionHelper.findMethod(CriteriaTriggers.class, (String)ObfuscationData.CRITERIATRIGGERS_REGISTER[0], (String)ObfuscationData.CRITERIATRIGGERS_REGISTER[1], (Class[])new Class[]{ICriterionTrigger.class});
        try {
            return (T)((ICriterionTrigger)method.invoke(null, criterion));
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

