/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.m_guide.client;

import com.valkyrieofnight.vlib.legacy.util.helpers.LanguageHelper;
import com.valkyrieofnight.vlib.lib.client.gui.VLGuiResources;
import com.valkyrieofnight.vlib.lib.client.gui.VLGuiScreen;
import com.valkyrieofnight.vlib.lib.client.gui.elements.VLElement;
import com.valkyrieofnight.vlib.lib.client.gui.elements.VLElementIndex;
import com.valkyrieofnight.vlib.lib.client.gui.elements.button.VLButtonIcon;
import com.valkyrieofnight.vlib.lib.client.gui.elements.container.VLContScissorPane;
import com.valkyrieofnight.vlib.lib.client.gui.elements.sizablebox.VLElementGuiSizableBox;
import com.valkyrieofnight.vlib.lib.client.gui.elements.sizablebox.VLElementSizablePanel;
import com.valkyrieofnight.vlib.lib.client.util.GridAlignment;
import com.valkyrieofnight.vlib.lib.util.NetworkUtil;
import com.valkyrieofnight.vlib.m_guide.client.ModGuideEntry;
import com.valkyrieofnight.vlib.m_guide.client.elements.ButtonMetro;
import com.valkyrieofnight.vlib.m_guide.client.elements.ModGuide;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class GuiGuide
extends VLGuiScreen {
    protected static List<ModGuideEntry> GUIDE_ENTRIES = new ArrayList<ModGuideEntry>();
    VLGuiResources GR;
    private VLButtonIcon patreon;
    private VLButtonIcon twitter;
    private VLButtonIcon discord;
    private VLButtonIcon curseforge;
    private VLButtonIcon youtube;
    private VLButtonIcon twitch;
    private VLButtonIcon home;
    private VLButtonIcon next;
    private VLButtonIcon prev;
    private VLElementIndex guideIndex;
    private MainMenu mainMenu;
    private GridAlignment grid = new GridAlignment(120, 56, 4, 4, 3, GridAlignment.Alignment.VERTICAL);
    ModGuide cmg;

    public static void addGuide(ModGuideEntry guideEntry) {
        if (guideEntry != null) {
            GUIDE_ENTRIES.add(guideEntry);
        }
    }

    public GuiGuide(EntityPlayer player) {
        int guiWidth = 384;
        int guiHeight = 212;
        this.func_183500_a(guiWidth, guiHeight);
        this.setGuiMaxSize(guiWidth, guiHeight);
        this.addElement(new VLElementGuiSizableBox("guide.gui.bg", VLGuiResources.GUI_STYLE_6));
        this.addElement(new VLElementSizablePanel("guide.screenbg", VLGuiResources.METRO_CC_BLACK, 4, 4, 376, 184));
        int iy = guiHeight - 20;
        this.patreon = new VLButtonIcon("guide.button.patreon", 4, iy, 16, 16, VLGuiResources.LOGO_PATREON_NAVY_WHITE);
        this.addElement(this.patreon);
        this.patreon.setBg(VLGuiResources.METRO_PATREON_CORAL);
        this.patreon.setIconMo(VLGuiResources.LOGO_PATREON_CORAL_WHITE);
        this.patreon.setBgMo(VLGuiResources.METRO_PATREON_NAVY);
        this.patreon.setBgDisabled(VLGuiResources.METRO_A_GRAY);
        this.patreon.addToolTip(LanguageHelper.toLoc("guide.valkyrielib.button.patreon"));
        this.twitter = new VLButtonIcon("guide.button.twitter", 24, iy, 16, 16, VLGuiResources.LOGO_TWITTER_WHITE);
        this.addElement(this.twitter);
        this.twitter.addToolTip(LanguageHelper.toLoc("guide.valkyrielib.button.twitter"));
        this.twitter.setBg(VLGuiResources.METRO_TWITTER_BLUE);
        this.twitter.setBgMo(VLGuiResources.METRO_A_WHITE);
        this.twitter.setIconMo(VLGuiResources.LOGO_TWITTER_BLUE);
        this.discord = new VLButtonIcon("guide.button.discord", 44, iy, 16, 16, VLGuiResources.LOGO_DISCORD_WHITE);
        this.addElement(this.discord);
        this.discord.setBg(VLGuiResources.METRO_DISCORD_BURPLE);
        this.discord.setIconMo(VLGuiResources.LOGO_DISCORD_BLUE);
        this.discord.setBgMo(VLGuiResources.METRO_A_WHITE);
        this.discord.addToolTip(LanguageHelper.toLoc("guide.valkyrielib.button.discord"));
        this.curseforge = new VLButtonIcon("guide.button.curseforge", 64, iy, 16, 16, VLGuiResources.LOGO_CURSEFORGE);
        this.addElement(this.curseforge);
        this.curseforge.setBg(VLGuiResources.METRO_CURSEFORGE_GREEN);
        this.curseforge.setBgMo(VLGuiResources.METRO_CURSEFORGE_ORANGE);
        this.curseforge.setBgDisabled(VLGuiResources.METRO_A_GRAY);
        this.curseforge.addToolTip(LanguageHelper.toLoc("guide.valkyrielib.button.curseforge"));
        int hx = guiWidth / 2 - 8;
        this.home = new VLButtonIcon("guide.button.home", hx, iy, 16, 16, VLGuiResources.METRO_HOME_WHITE);
        this.addElement(this.home);
        this.home.addToolTip(LanguageHelper.toLoc("gui.valkyrielib.home"));
        this.home.setBg(VLGuiResources.METRO_DISCORD_GRAY);
        this.home.setBgMo(VLGuiResources.METRO_A_LIGHT_BLUE);
        int px = hx - 20;
        this.prev = new VLButtonIcon("guide.button.prev", px, iy, 16, 16, VLGuiResources.METRO_PREV_WHITE);
        this.addElement(this.prev);
        this.prev.addToolTip(LanguageHelper.toLoc("gui.valkyrielib.prev"));
        this.prev.setBg(VLGuiResources.METRO_DISCORD_GRAY);
        this.prev.setBgMo(VLGuiResources.METRO_A_LIGHT_BLUE);
        int nx = hx + 20;
        this.next = new VLButtonIcon("guide.button.next", nx, iy, 16, 16, VLGuiResources.METRO_NEXT_WHITE);
        this.addElement(this.next);
        this.next.addToolTip(LanguageHelper.toLoc("gui.valkyrielib.next"));
        this.next.setBg(VLGuiResources.METRO_DISCORD_GRAY);
        this.next.setBgMo(VLGuiResources.METRO_A_LIGHT_BLUE);
        this.guideIndex = new VLElementIndex("guide.mainindex"){

            @Override
            public void init() {
            }

            @Override
            public void onElementResize(VLElement ele) {
            }
        };
        this.addElement(this.guideIndex);
        this.mainMenu = new MainMenu(this, "guide.mainmenu", 376, 184);
        this.guideIndex.addIndex(this.mainMenu);
        this.guideIndex.setIndex("guide.mainmenu");
        this.mainMenu.setXPosOffset(4);
        this.mainMenu.setYPosOffset(4);
        Collections.sort(GUIDE_ENTRIES);
        for (ModGuideEntry cl : GUIDE_ENTRIES) {
            ModGuide mg = cl.getModGuide();
            mg.setGuidePageSize(this.mainMenu.getXSize(), this.mainMenu.getYSize());
            this.addModGuide(mg);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.cmg == null) {
            VLElement t = this.guideIndex.getCurrentIndex();
            this.cmg = t instanceof ModGuide ? (ModGuide)t : null;
        } else if (this.guideIndex.getCurrentIndex() == this.mainMenu) {
            this.cmg = null;
        }
        if (this.cmg != null) {
            this.next.setEnabled(this.cmg.hasNext());
            this.prev.setEnabled(this.cmg.hasPrev());
        } else if (this.guideIndex.getCurrentIndex() == this.mainMenu) {
            this.next.setEnabled(false);
            this.prev.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
        if (mouseButton != 0) {
            return;
        }
        if (this.patreon == ele) {
            NetworkUtil.openLink("https://www.patreon.com/ValkyrieofNight");
        } else if (this.twitter == ele) {
            NetworkUtil.openLink("https://twitter.com/ValkyrieofNight");
        } else if (this.discord == ele) {
            NetworkUtil.openLink("https://discord.gg/5qzseB3");
        } else if (this.curseforge == ele) {
            NetworkUtil.openLink("https://www.curseforge.com/members/ValkyrieofNight/projects");
        } else if (this.prev == ele) {
            ModGuide mg;
            if (this.guideIndex.getCurrentIndex() != null && this.guideIndex.getCurrentIndex() instanceof ModGuide && (mg = (ModGuide)this.guideIndex.getCurrentIndex()).hasPrev()) {
                mg.prev();
            }
        } else if (this.home == ele) {
            ModGuide mg;
            if (this.guideIndex.getCurrentIndex() != null && this.guideIndex.getCurrentIndex() instanceof ModGuide && (mg = (ModGuide)this.guideIndex.getCurrentIndex()).home()) {
                this.guideIndex.setIndex(this.mainMenu.getID());
            }
        } else if (this.next == ele) {
            ModGuide mg;
            if (this.guideIndex.getCurrentIndex() != null && this.guideIndex.getCurrentIndex() instanceof ModGuide && (mg = (ModGuide)this.guideIndex.getCurrentIndex()).hasNext()) {
                mg.next();
            }
        } else if (ele instanceof ButtonMetro) {
            this.setGuide(ele.getID());
        }
    }

    protected void setGuide(String guide) {
        VLElement g = this.guideIndex.getIndex(guide);
        if (g instanceof ModGuide) {
            ModGuide mg = (ModGuide)g;
            this.guideIndex.setIndex(guide);
        }
    }

    @Override
    public void mouseScrolled(VLElement ele, int mx, int my, int scroll) {
    }

    @Override
    public void keyTyped(VLElement ele, char character, int keyCode) {
    }

    public void addMainMenuButton(ButtonMetro button) {
        button.setPos(4 + this.grid.getCurrentXOffset(), 4 + this.grid.getCurrentYOffset());
        this.grid.next();
        this.mainMenu.addElement(button);
        this.mainMenu.setScrollMin(0, 0);
        this.mainMenu.setScrollMax(0, 2000);
    }

    public void addSupportPage() {
    }

    public void addModGuide(ModGuide modGuide) {
        if (modGuide == null) {
            return;
        }
        this.guideIndex.addIndex(modGuide);
        modGuide.setXPosOffset(4);
        modGuide.setYPosOffset(4);
        modGuide.setXSize(this.mainMenu.getXSize());
        modGuide.setYSize(this.mainMenu.getYSize());
        ButtonMetro but = modGuide.getButton();
        this.addMainMenuButton(but);
    }

    protected class MainMenu
    extends VLContScissorPane {
        GuiGuide gui;

        public MainMenu(GuiGuide gui, String elementID, int xSize, int ySize) {
            super(elementID, xSize, ySize);
            this.gui = gui;
        }

        @Override
        public void mouseClicked(VLElement ele, int mx, int my, int mouseButton) {
            this.gui.mouseClicked(ele, mx, my, mouseButton);
        }

        @Override
        public void addElements() {
        }
    }
}

