/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.ModConfig;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.BlockCounter;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.tile.DoorAnimator;
import net.blay09.mods.cookingforblockheads.tile.IDyeableKitchen;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vazkii.quark.api.IDropoffManager;

@Optional.Interface(modid="quark", iface="vazkii.quark.api.IDropoffManager", striprefs=true)
public class TileCounter
extends TileEntity
implements ITickable,
IDropoffManager,
IDyeableKitchen {
    private final ItemStackHandler itemHandler;
    private final KitchenItemProvider itemProvider;
    private final DoorAnimator doorAnimator;
    private boolean isFirstTick;
    private boolean isDirty;
    private EnumDyeColor color;
    private EnumFacing cachedFacing;
    private boolean cachedFlipped;

    public TileCounter() {
        this.itemHandler = new ItemStackHandler(ModConfig.general.largeCounters ? 54 : 27){

            protected void onContentsChanged(int slot) {
                TileCounter.this.isDirty = true;
                TileCounter.this.func_70296_d();
            }
        };
        this.itemProvider = new KitchenItemProvider((IItemHandler)this.itemHandler);
        this.doorAnimator = new DoorAnimator(this, 1, 2);
        this.isFirstTick = true;
        this.color = EnumDyeColor.WHITE;
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen(SoundEvents.field_187657_V);
        this.doorAnimator.setSoundEventClose(SoundEvents.field_187651_T);
    }

    public void func_73660_a() {
        IBlockState state;
        if (this.isFirstTick && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == ModBlocks.counter) {
            this.cachedFacing = (EnumFacing)state.func_177229_b((IProperty)BlockCounter.FACING);
            this.cachedFlipped = (Boolean)state.func_177229_b((IProperty)BlockCounter.FLIPPED);
            this.isFirstTick = false;
        }
        this.doorAnimator.update();
        if (this.isDirty) {
            VanillaPacketHandler.sendTileEntityUpdate(this);
            this.isDirty = false;
        }
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.color = EnumDyeColor.func_176766_a((int)tagCompound.func_74771_c("Color"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        tagCompound.func_74774_a("Color", (byte)this.color.func_176767_b());
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        this.doorAnimator.setForcedOpen(pkt.func_148857_g().func_74767_n("IsForcedOpen"));
        this.doorAnimator.setNumPlayersUsing(pkt.func_148857_g().func_74771_c("NumPlayersUsing"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        tagCompound.func_74757_a("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tagCompound.func_74774_a("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
        return tagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityKitchenItemProvider.CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (capability == CapabilityKitchenItemProvider.CAPABILITY) {
            return (T)this.itemProvider;
        }
        return (T)super.getCapability(capability, facing);
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    @Override
    public void setDyedColor(EnumDyeColor color) {
        this.color = color;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), state, state, 3);
        this.func_70296_d();
    }

    @Override
    public EnumDyeColor getDyedColor() {
        return this.color;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            this.cachedFacing = (EnumFacing)newState.func_177229_b((IProperty)BlockCounter.FACING);
            this.cachedFlipped = (Boolean)newState.func_177229_b((IProperty)BlockCounter.FLIPPED);
            return false;
        }
        return true;
    }

    public EnumFacing getFacing() {
        if (this.cachedFacing == null) {
            return EnumFacing.NORTH;
        }
        return this.cachedFacing;
    }

    public boolean isFlipped() {
        return this.cachedFlipped;
    }

    public boolean acceptsDropoff(EntityPlayer entityPlayer) {
        return true;
    }
}

