/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.common;

import com.google.common.collect.Lists;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.MathHelper;

public class PropertyValueMapper {
    private static final Comparator<? super IProperty<?>> COMPARATOR_BIT_FITNESS = (first, second) -> {
        int diff2;
        int diff1 = PropertyValueMapper.getPropertyEntry(first).bitSize - first.func_177700_c().size();
        if (diff1 == (diff2 = PropertyValueMapper.getPropertyEntry(second).bitSize - second.func_177700_c().size())) {
            return first.func_177701_a().compareTo(second.func_177701_a());
        }
        return diff1 - diff2;
    };
    private static final Map<IProperty, Entry> entryMap = new IdentityHashMap<IProperty, Entry>();
    private static final Map<BlockStateContainer, PropertyValueMapper> mapperMap = new IdentityHashMap<BlockStateContainer, PropertyValueMapper>();
    private final Entry[] entryList;
    private final TObjectIntMap<String> entryPositionMap;
    private final IBlockState[] stateMap;

    public PropertyValueMapper(BlockStateContainer container) {
        Collection properties = container.func_177623_d();
        this.entryList = new Entry[properties.size()];
        ArrayList propertiesSortedFitness = Lists.newArrayList((Iterable)properties);
        Collections.sort(propertiesSortedFitness, COMPARATOR_BIT_FITNESS);
        int i = 0;
        for (IProperty p : propertiesSortedFitness) {
            this.entryList[i++] = PropertyValueMapper.getPropertyEntry(p);
        }
        this.entryPositionMap = new TObjectIntHashMap(10, 0.5f, -1);
        int bitPos = 0;
        Entry lastEntry = null;
        for (Entry ee : this.entryList) {
            this.entryPositionMap.put((Object)ee.property.func_177701_a(), bitPos);
            bitPos += ee.bits;
            lastEntry = ee;
        }
        this.stateMap = lastEntry == null ? new IBlockState[1 << bitPos] : new IBlockState[(1 << bitPos - lastEntry.bits) * lastEntry.property.func_177700_c().size()];
    }

    public static PropertyValueMapper getOrCreate(BlockStateContainer owner) {
        PropertyValueMapper e = mapperMap.get(owner);
        if (e == null) {
            e = new PropertyValueMapper(owner);
            mapperMap.put(owner, e);
        }
        return e;
    }

    protected static Entry getPropertyEntry(IProperty property) {
        Entry e = entryMap.get(property);
        if (e == null) {
            e = new Entry(property);
            entryMap.put(property, e);
        }
        return e;
    }

    protected int generateValue(IBlockState state) {
        int bitPos = 0;
        int value = 0;
        for (Entry e : this.entryList) {
            value |= e.get(state.func_177229_b(e.property)) << bitPos;
            bitPos += e.bits;
        }
        this.stateMap[value] = state;
        return value;
    }

    public <T extends Comparable<T>, V extends T> IBlockState withProperty(int value, IProperty<T> property, V propertyValue) {
        Entry e;
        int bitPos = this.entryPositionMap.get((Object)property.func_177701_a());
        if (bitPos >= 0 && (e = PropertyValueMapper.getPropertyEntry(property)) != null) {
            int nv = e.get(propertyValue);
            if (nv < 0) {
                return null;
            }
            value &= ~(e.bitSize - 1 << bitPos);
            return this.stateMap[value |= nv << bitPos];
        }
        return null;
    }

    public IBlockState getPropertyByValue(int value) {
        return this.stateMap[value];
    }

    public <T extends Comparable<T>, V extends T> int withPropertyValue(int value, IProperty<T> property, V propertyValue) {
        Entry e;
        int bitPos = this.entryPositionMap.get((Object)property.func_177701_a());
        if (bitPos >= 0 && (e = PropertyValueMapper.getPropertyEntry(property)) != null) {
            int bitMask = e.bitSize - 1;
            int nv = e.get(propertyValue);
            if (nv < 0) {
                return -1;
            }
            value &= ~(bitMask << bitPos);
            return value |= nv << bitPos;
        }
        return -1;
    }

    public static class Entry {
        private final IProperty property;
        private final TObjectIntMap values;
        private final int bitSize;
        private final int bits;

        private Entry(IProperty property) {
            this.property = property;
            this.values = new TObjectIntHashMap(10, 0.5f, -1);
            this.bitSize = MathHelper.func_151236_b((int)property.func_177700_c().size());
            int bits = 0;
            for (int b = this.bitSize - 1; b != 0; b >>= 1) {
                ++bits;
            }
            this.bits = bits;
            int i = 0;
            Collection allowedValues = property.func_177700_c();
            for (Object o : allowedValues) {
                this.values.put(o, i++);
            }
        }

        public int get(Object v) {
            return this.values.get(v);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            return ((Entry)other).property.equals(this.property);
        }

        public int hashCode() {
            return this.property.hashCode();
        }
    }
}

