/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.network;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import p455w0rd.danknull.DankNull;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.client.gui.GuiDankNull;
import p455w0rd.danknull.container.ContainerDankNull;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.util.DankNullUtils;
import p455w0rdslib.util.EasyMappings;

public class PacketSyncDankNull
implements IMessage {
    private NonNullList<ItemStack> itemStacks;
    private int[] stackSizes;
    private Map<ItemStack, DankNullUtils.SlotExtractionMode> extractionModes = Maps.newHashMap();
    private Map<ItemStack, Boolean> oreDictModes = Maps.newHashMap();
    private BlockPos pos = null;
    private static final String TEMP_EXTRACT_TAG = "ExtractionMode";
    private static final String TEMP_OREDICT_TAG = "OreDictMode";
    private boolean isLocked;

    public void fromBytes(ByteBuf buf) {
        int oreDictModesSize;
        int j;
        int i = buf.readShort();
        this.itemStacks = NonNullList.func_191197_a((int)i, (Object)ItemStack.field_190927_a);
        this.stackSizes = new int[i];
        for (j = 0; j < i; ++j) {
            this.itemStacks.set(j, (Object)ByteBufUtils.readItemStack((ByteBuf)buf));
        }
        for (j = 0; j < i; ++j) {
            this.stackSizes[j] = buf.readInt();
        }
        int extractionModesSize = buf.readInt();
        if (extractionModesSize > 0) {
            for (int k = 0; k < extractionModesSize; ++k) {
                ItemStack currentStack = ByteBufUtils.readItemStack((ByteBuf)buf);
                currentStack.func_190920_e(1);
                DankNullUtils.SlotExtractionMode mode = DankNullUtils.SlotExtractionMode.values()[currentStack.func_77978_p().func_74762_e(TEMP_EXTRACT_TAG)];
                this.extractionModes.put(currentStack, mode);
            }
        }
        if ((oreDictModesSize = buf.readInt()) > 0) {
            for (int k = 0; k < oreDictModesSize; ++k) {
                ItemStack currentStack = ByteBufUtils.readItemStack((ByteBuf)buf);
                currentStack.func_190920_e(1);
                this.oreDictModes.put(currentStack, currentStack.func_77978_p().func_74767_n(TEMP_OREDICT_TAG));
            }
        }
        if (buf.readBoolean()) {
            int x = buf.readInt();
            int y = buf.readInt();
            int z = buf.readInt();
            this.pos = new BlockPos(x, y, z);
        }
        this.isLocked = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.itemStacks.size());
        for (ItemStack itemstack : this.itemStacks) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)itemstack);
        }
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            buf.writeInt(this.stackSizes[i]);
        }
        buf.writeInt(this.extractionModes.size());
        if (!this.extractionModes.isEmpty()) {
            for (ItemStack stack : this.extractionModes.keySet()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a(TEMP_EXTRACT_TAG, this.extractionModes.get(stack).ordinal());
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
            }
        }
        buf.writeInt(this.oreDictModes.size());
        if (!this.oreDictModes.isEmpty()) {
            for (ItemStack stack : this.oreDictModes.keySet()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74757_a(TEMP_OREDICT_TAG, this.oreDictModes.get(stack).booleanValue());
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
            }
        }
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.pos.func_177958_n());
            buf.writeInt(this.pos.func_177956_o());
            buf.writeInt(this.pos.func_177952_p());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.isLocked);
    }

    public PacketSyncDankNull() {
    }

    public PacketSyncDankNull(@Nonnull ItemStack dankNullIn) {
        this(DankNullUtils.getNewDankNullInventory(dankNullIn));
    }

    public PacketSyncDankNull(@Nonnull ItemStack dankNullIn, BlockPos posIn) {
        this(DankNullUtils.getNewDankNullInventory(dankNullIn), posIn);
    }

    public PacketSyncDankNull(@Nonnull InventoryDankNull inv) {
        this(inv, null);
    }

    public PacketSyncDankNull(@Nonnull InventoryDankNull inv, BlockPos posIn) {
        this.itemStacks = NonNullList.func_191197_a((int)inv.getStacks().size(), (Object)ItemStack.field_190927_a);
        this.stackSizes = new int[inv.getStacks().size()];
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            ItemStack itemstack = (ItemStack)inv.getStacks().get(i);
            this.itemStacks.set(i, (Object)itemstack.func_77946_l());
            this.stackSizes[i] = itemstack.func_190916_E();
        }
        if (!DankNullUtils.getExtractionModes(inv.getDankNull()).isEmpty()) {
            this.extractionModes = DankNullUtils.getExtractionModes(inv.getDankNull());
        }
        if (!DankNullUtils.getOreDictModes(inv.getDankNull()).isEmpty()) {
            this.oreDictModes = DankNullUtils.getOreDictModes(inv.getDankNull());
        }
        if (posIn != null) {
            this.pos = posIn;
        }
        this.isLocked = DankNullUtils.isCreativeDankNullLocked(inv.getDankNull());
    }

    public static class Handler
    implements IMessageHandler<PacketSyncDankNull, IMessage> {
        public IMessage onMessage(PacketSyncDankNull message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                if (ctx.side == Side.CLIENT) {
                    this.handleToClient(message, ctx);
                } else {
                    this.handleToServer(message, ctx);
                }
            });
            return null;
        }

        private void handleToServer(PacketSyncDankNull message, MessageContext ctx) {
            this.handle(message, (EntityPlayer)ctx.getServerHandler().field_147369_b, ctx.side);
        }

        private void handleToClient(PacketSyncDankNull message, MessageContext ctx) {
            this.handle(message, EasyMappings.player(), ctx.side);
        }

        private void handle(PacketSyncDankNull message, EntityPlayer player, Side side) {
            World world;
            TileEntity te;
            ContainerDankNull container;
            ItemStack dankNull;
            InventoryDankNull inv = null;
            if (player.field_71070_bA instanceof ContainerDankNull && !(dankNull = (container = (ContainerDankNull)player.field_71070_bA).getDankNull()).func_190926_b()) {
                inv = DankNullUtils.getNewDankNullInventory(dankNull);
                for (int i = 0; i < message.itemStacks.size(); ++i) {
                    ((ItemStack)message.itemStacks.get(i)).func_190920_e(DankNullUtils.isCreativeDankNull(dankNull) ? Integer.MAX_VALUE : message.stackSizes[i]);
                    container.func_75141_a(i + 36, (ItemStack)message.itemStacks.get(i));
                }
                if (!message.extractionModes.isEmpty()) {
                    DankNullUtils.setExtractionModes(inv.getDankNull(), message.extractionModes);
                }
                if (!message.oreDictModes.isEmpty()) {
                    DankNullUtils.setOreDictModes(inv.getDankNull(), message.oreDictModes);
                }
                if (DankNullUtils.isCreativeDankNull(inv.getDankNull())) {
                    DankNullUtils.setLocked(inv.getDankNull(), message.isLocked);
                }
            }
            if (message.pos != null && (te = (world = player.func_130014_f_()).func_175625_s(message.pos)) != null && te instanceof TileDankNullDock) {
                TileDankNullDock dankDock = (TileDankNullDock)te;
                if (inv != null) {
                    dankDock.setInventory(inv);
                } else {
                    inv = dankDock.getInventory();
                }
                ItemStack dankNull2 = inv.getDankNull();
                if (!dankNull2.func_190926_b()) {
                    dankDock.setStack(dankNull2);
                    for (int i = 0; i < message.itemStacks.size(); ++i) {
                        ((ItemStack)message.itemStacks.get(i)).func_190920_e(DankNullUtils.isCreativeDankNull(dankNull2) ? Integer.MAX_VALUE : message.stackSizes[i]);
                        inv.func_70299_a(i, (ItemStack)message.itemStacks.get(i));
                    }
                    if (!message.extractionModes.isEmpty()) {
                        DankNullUtils.setExtractionModes(dankNull2, message.extractionModes);
                    }
                    if (!message.oreDictModes.isEmpty()) {
                        DankNullUtils.setOreDictModes(inv.getDankNull(), message.oreDictModes);
                    }
                    if (DankNullUtils.isCreativeDankNull(inv.getDankNull())) {
                        DankNullUtils.setLocked(inv.getDankNull(), message.isLocked);
                    }
                }
            }
            if (side == Side.CLIENT && inv != null && DankNull.PROXY.getScreen() != null && DankNull.PROXY.getScreen() instanceof GuiDankNull) {
                GuiDankNull screen = (GuiDankNull)DankNull.PROXY.getScreen();
                screen.setDankNull(inv.getDankNull());
            }
            if (side == Side.SERVER) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }
}

