/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.client.gui.GuiDankNull;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModGuiHandler;
import p455w0rd.danknull.init.ModIntegration;
import p455w0rd.danknull.init.ModKeyBindings;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.init.ModRecipes;
import p455w0rd.danknull.integration.NEI;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.network.PacketSyncDankNull;
import p455w0rd.danknull.util.DankNullUtils;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.ItemUtils;

public class ModEvents {
    private static final ModEvents INSTANCE = new ModEvents();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    public static ModEvents getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onRecipeRegistryReady(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModRecipes.getInstance().getArray());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelRegistryReady(ModelRegistryEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlayEvent(RenderGameOverlayEvent e) {
        if (ModGlobals.GUI_DANKNULL_ISOPEN && (e.getType() == RenderGameOverlayEvent.ElementType.HOTBAR || e.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS || e.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE || e.getType() == RenderGameOverlayEvent.ElementType.FOOD || e.getType() == RenderGameOverlayEvent.ElementType.HEALTH || e.getType() == RenderGameOverlayEvent.ElementType.ARMOR)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent e) {
        InventoryDankNull inventory;
        EntityPlayer player = e.getEntityPlayer();
        ItemStack entityStack = e.getItem().func_92059_d();
        if (entityStack.func_190926_b() || player == null) {
            return;
        }
        ItemStack dankNull = DankNullUtils.getDankNullForStack(player, entityStack);
        if (!dankNull.func_190926_b() && (inventory = DankNullUtils.getInventoryFromStack(dankNull)) != null && DankNullUtils.addFilteredStackToDankNull(inventory, entityStack)) {
            entityStack.func_190920_e(0);
            player.func_130014_f_().func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, player.func_184176_by(), 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        EntityPlayer player = EasyMappings.player();
        ItemStack dankNullItem = ItemStack.field_190927_a;
        dankNullItem = DankNullUtils.getDankNull(player);
        InventoryDankNull inventory = DankNullUtils.getInventoryFromHeld(player);
        if (dankNullItem.func_190926_b() || !DankNullUtils.isDankNull(dankNullItem)) {
            return;
        }
        if (ModKeyBindings.getOpenDankNullKeyBind().func_151468_f()) {
            BlockPos playerPos = player.func_180425_c();
            ModGuiHandler.launchGui(ModGuiHandler.GUIType.DANKNULL, player, (World)Minecraft.func_71410_x().field_71441_e, playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p());
        }
        int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
        int totalSize = DankNullUtils.getItemCount(inventory);
        if (currentIndex == -1 || totalSize <= 1) {
            return;
        }
        if (ModKeyBindings.getNextItemKeyBind().func_151468_f()) {
            DankNullUtils.setNextSelectedStack(inventory, player);
        } else if (ModKeyBindings.getPreviousItemKeyBind().func_151468_f()) {
            DankNullUtils.setPreviousSelectedStack(inventory, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseEventCustom(GuiScreenEvent.MouseInputEvent event) {
        if (Mouse.getEventButtonState() && Mouse.getEventButton() == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r instanceof GuiDankNull) {
                int mouseY;
                GuiDankNull dankNullGui = (GuiDankNull)mc.field_71462_r;
                int width = dankNullGui.field_146294_l;
                int height = dankNullGui.field_146295_m;
                int mouseX = Mouse.getEventX() * width / mc.field_71443_c;
                Slot hoveredSlot = dankNullGui.getSlotAtPos(mouseX, mouseY = height - Mouse.getEventY() * height / mc.field_71440_d - 1);
                if (hoveredSlot != null && hoveredSlot.func_75216_d() && Mouse.isButtonDown((int)0)) {
                    if (GuiScreen.func_146271_m() && !GuiScreen.func_175283_s()) {
                        DankNullUtils.cycleExtractionMode(dankNullGui.getDankNull(), hoveredSlot.func_75211_c());
                        ModNetworking.getInstance().sendToServer((IMessage)new PacketSyncDankNull(dankNullGui.getDankNull()));
                        event.setCanceled(true);
                    } else if (GuiScreen.func_175283_s() && !GuiScreen.func_146271_m()) {
                        if (!ItemUtils.areItemsEqual((ItemStack)DankNullUtils.getSelectedStack(dankNullGui.getDankNullInventory()), (ItemStack)hoveredSlot.func_75211_c())) {
                            int count = 0;
                            for (Slot slotHovered : dankNullGui.field_147002_h.field_75151_b) {
                                ++count;
                                if (!slotHovered.equals(hoveredSlot)) continue;
                                if (dankNullGui.getDock() != null) {
                                    DankNullUtils.setSelectedStackIndex(dankNullGui.getDankNullInventory(), count - 1 - 36, dankNullGui.getDock().func_145831_w(), dankNullGui.getDock().func_174877_v());
                                } else {
                                    DankNullUtils.setSelectedStackIndex(dankNullGui.getDankNullInventory(), count - 1 - 36);
                                }
                                event.setCanceled(true);
                            }
                        }
                    } else if (Keyboard.isKeyDown((int)24) && !GuiScreen.func_175283_s() && !GuiScreen.func_146271_m() && (DankNullUtils.isOreDictBlacklistEnabled() && !DankNullUtils.isItemOreDictBlacklisted(hoveredSlot.func_75211_c()) || DankNullUtils.isOreDictWhitelistEnabled() && DankNullUtils.isItemOreDictWhitelisted(hoveredSlot.func_75211_c()) || !DankNullUtils.isOreDictBlacklistEnabled() && !DankNullUtils.isOreDictWhitelistEnabled())) {
                        DankNullUtils.cycleOreDictModeForStack(dankNullGui.getDankNull(), hoveredSlot.func_75211_c());
                        ModNetworking.getInstance().sendToServer((IMessage)new PacketSyncDankNull(dankNullGui.getDankNull()));
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseEvent(MouseEvent event) {
        EntityPlayer player = EasyMappings.player();
        ItemStack dankNullItem = ItemStack.field_190927_a;
        dankNullItem = DankNullUtils.getDankNull(player);
        InventoryDankNull inventory = DankNullUtils.getInventoryFromHeld(player);
        if (dankNullItem.func_190926_b() || !DankNullUtils.isDankNull(dankNullItem)) {
            return;
        }
        if (event.getDwheel() == 0) {
            int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
            int totalSize = DankNullUtils.getItemCount(inventory);
            if (currentIndex == -1 || totalSize <= 1) {
                return;
            }
            if (ModKeyBindings.getNextItemKeyBind().func_151468_f()) {
                DankNullUtils.setNextSelectedStack(inventory, player);
                event.setCanceled(true);
            } else if (ModKeyBindings.getPreviousItemKeyBind().func_151468_f()) {
                DankNullUtils.setPreviousSelectedStack(inventory, player);
                event.setCanceled(true);
            }
        } else if (player.func_70093_af()) {
            int currentIndex = DankNullUtils.getSelectedStackIndex(inventory);
            int totalSize = DankNullUtils.getItemCount(inventory);
            if (currentIndex == -1 || totalSize <= 1) {
                return;
            }
            int scrollForward = event.getDwheel();
            if (scrollForward < 0) {
                DankNullUtils.setNextSelectedStack(inventory, player);
                event.setCanceled(true);
            } else if (scrollForward > 0) {
                DankNullUtils.setPreviousSelectedStack(inventory, player);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = event.getPos();
        EnumHand hand = event.getHand();
        TileDankNullDock te = null;
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileDankNullDock) {
            te = (TileDankNullDock)world.func_175625_s(pos);
        }
        if (te != null && player.func_184586_b(hand).func_190926_b() && player.func_70093_af() && !te.getStack().func_190926_b()) {
            player.func_184611_a(hand, te.getStack());
            te.setStack(ItemStack.field_190927_a);
            te.setSelectedStack(ItemStack.field_190927_a);
            te.resetInventory();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostRenderOverlay(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            DankNullUtils.renderHUD(mc, new ScaledResolution(mc));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerLoggedIn(WorldEvent.Load e) {
        if (ModIntegration.Mods.NEI.isLoaded() && FMLCommonHandler.instance().getSide().isClient()) {
            NEI.init();
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("danknull")) {
            ModConfig.init();
        }
    }
}

