/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.render.IModelRegister;
import cofh.core.render.particle.EntityDropParticleFX;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidCore
extends BlockFluidClassic
implements IInitializer,
IModelRegister {
    protected String modName;
    protected String name;
    protected float particleRed = 1.0f;
    protected float particleGreen = 1.0f;
    protected float particleBlue = 1.0f;
    protected boolean shouldDisplaceFluids = false;

    public BlockFluidCore(Fluid fluid, Material material, String modName, String name) {
        super(fluid, material);
        this.name = name;
        this.modName = modName;
        this.func_149663_c(modName + ".fluid." + name);
        this.displacements.put(this, false);
    }

    public BlockFluidCore(Fluid fluid, Material material, String name) {
        this(fluid, material, "cofh", name);
    }

    public BlockFluidCore setParticleColor(int c) {
        return this.setParticleColor((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f);
    }

    public BlockFluidCore setParticleColor(float particleRed, float particleGreen, float particleBlue) {
        this.particleRed = particleRed;
        this.particleGreen = particleGreen;
        this.particleBlue = particleBlue;
        return this;
    }

    public BlockFluidCore setDisplaceFluids(boolean a) {
        this.shouldDisplaceFluids = a;
        return this;
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        double fluidHeight;
        if (this.density < 0) {
            return null;
        }
        if (iblockstate.func_185904_a().func_76224_d() && yToTest >= (fluidHeight = (double)((float)(blockpos.func_177956_o() + 1) - BlockLiquid.func_149801_b((int)((Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b)))))) {
            return true;
        }
        return super.isEntityInsideMaterial(world, blockpos, iblockstate, entity, yToTest, materialIn, testingHead);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double px = (float)pos.func_177958_n() + rand.nextFloat();
        double py = (double)pos.func_177956_o() - 1.05;
        double pz = (float)pos.func_177952_p() + rand.nextFloat();
        if (this.density < 0) {
            py = (double)pos.func_177956_o() + 2.1;
        }
        if (rand.nextInt(20) == 0 && world.isSideSolid(pos.func_177982_a(0, this.densityDir, 0), this.densityDir == -1 ? EnumFacing.UP : EnumFacing.DOWN) && !world.func_180495_p(pos.func_177982_a(0, 2 * this.densityDir, 0)).func_185904_a().func_76230_c()) {
            EntityDropParticleFX fx = new EntityDropParticleFX(world, px, py, pz, this.particleRed, this.particleGreen, this.particleBlue, this.densityDir);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (!this.shouldDisplaceFluids && world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (!this.shouldDisplaceFluids && world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public int getDensity() {
        return this.density;
    }

    public int getDensityDir() {
        return this.densityDir;
    }

    public float getParticleRed() {
        return this.particleRed;
    }

    public float getParticleGreen() {
        return this.particleGreen;
    }

    public float getParticleBlue() {
        return this.particleBlue;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return new Vec3d((double)this.getParticleRed(), (double)this.getParticleGreen(), (double)this.getParticleBlue());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        StateMapper mapper = new StateMapper(this.modName, "fluid", this.name);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
    }

    @Override
    public boolean preInit() {
        return false;
    }

    @Override
    public boolean initialize() {
        return false;
    }
}

