/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.machine;

import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CentrifugeParser
extends BaseParser {
    int defaultEnergy = 2000;

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement recipe : contentArray) {
            JsonElement outputElement;
            JsonObject content = recipe.getAsJsonObject();
            if (content.has("//")) continue;
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            ArrayList<Integer> chance = new ArrayList<Integer>();
            FluidStack fluid = null;
            int energy = this.defaultEnergy;
            ItemStack input = CentrifugeParser.parseItemStack(content.get("input"));
            if (content.has("output")) {
                outputElement = content.get("output");
                output.add(CentrifugeParser.parseItemStack(outputElement));
                chance.add(CentrifugeParser.getChance(outputElement));
            }
            if (content.has("output2")) {
                outputElement = content.get("output2");
                output.add(CentrifugeParser.parseItemStack(outputElement));
                chance.add(CentrifugeParser.getChance(outputElement));
            }
            if (content.has("output3")) {
                outputElement = content.get("output3");
                output.add(CentrifugeParser.parseItemStack(outputElement));
                chance.add(CentrifugeParser.getChance(outputElement));
            }
            if (content.has("output4")) {
                outputElement = content.get("output4");
                output.add(CentrifugeParser.parseItemStack(outputElement));
                chance.add(CentrifugeParser.getChance(outputElement));
            }
            if (content.has("fluid")) {
                fluid = CentrifugeParser.parseFluidStack(content.get("fluid"));
            }
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (CentrifugeManager.addRecipe(energy, input, output, chance, fluid) != null) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }
}

