/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.common.command.BOPCommand;
import biomesoplenty.common.handler.GuiHandler;
import biomesoplenty.common.init.ModBiomes;
import biomesoplenty.common.init.ModBlockQueries;
import biomesoplenty.common.init.ModBlocks;
import biomesoplenty.common.init.ModCompatibility;
import biomesoplenty.common.init.ModConfiguration;
import biomesoplenty.common.init.ModCrafting;
import biomesoplenty.common.init.ModEntities;
import biomesoplenty.common.init.ModGenerators;
import biomesoplenty.common.init.ModHandlers;
import biomesoplenty.common.init.ModItems;
import biomesoplenty.common.init.ModPotions;
import biomesoplenty.common.init.ModSounds;
import biomesoplenty.common.init.ModVanillaCompat;
import biomesoplenty.common.remote.TrailManager;
import biomesoplenty.core.CommonProxy;
import java.io.File;
import java.util.Locale;
import net.minecraft.command.ICommand;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="biomesoplenty", version="7.0.1.2391", name="Biomes O' Plenty", dependencies="required-after:forge@[14.23.0.2528,)", guiFactory="biomesoplenty.client.gui.GuiBOPFactory", acceptedMinecraftVersions="[1.12.2]")
public class BiomesOPlenty {
    public static final String MOD_NAME = "Biomes O' Plenty";
    public static final String MOD_ID = "biomesoplenty";
    public static final String MOD_VERSION = "7.0.1.2391";
    public static final String GUI_FACTORY = "biomesoplenty.client.gui.GuiBOPFactory";
    @Mod.Instance(value="biomesoplenty")
    public static BiomesOPlenty instance;
    @SidedProxy(clientSide="biomesoplenty.core.ClientProxy", serverSide="biomesoplenty.core.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static File configDirectory;

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDirectory = new File(event.getModConfigurationDirectory(), MOD_ID);
        Locale.setDefault(Locale.ENGLISH);
        TrailManager.retrieveTrails();
        ModConfiguration.init(configDirectory);
        ModBlocks.init();
        ModSounds.init();
        ModEntities.init();
        ModItems.init();
        ModPotions.init();
        ModBlockQueries.init();
        ModGenerators.init();
        ModBiomes.init();
        ModVanillaCompat.init();
        ModHandlers.init();
        ModCrafting.init();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerColouring();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModCompatibility.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BOPCommand());
    }

    public File getConfigDirectory() {
        return configDirectory;
    }

    static {
        logger = LogManager.getLogger((String)MOD_ID);
    }
}

