/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.world.generator.GeneratorDoubleFlora;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorRedwoodTree;
import biomesoplenty.common.world.generator.tree.GeneratorRedwoodTreeThin;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;

public class BiomeGenRedwoodForest
extends BOPOverworldBiome {
    public BiomeGenRedwoodForest() {
        super("redwood_forest", new BOPBiome.PropsBuilder("Redwood Forest").withGuiColour(7187004).withTemperature(Float.valueOf(0.7f)).withRainfall(Float.valueOf(0.7f)));
        this.terrainSettings.avgHeight(70.0).heightVariation(1.0, 1.0);
        this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.addWeight(BOPClimates.WARM_TEMPERATE, 7);
        GeneratorWeighted treeGenerator = new GeneratorWeighted(10.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("redwood", 3, ((GeneratorRedwoodTree.Builder)((GeneratorRedwoodTree.Builder)new GeneratorRedwoodTree.Builder().log(BOPWoods.REDWOOD)).leaves(BOPTrees.REDWOOD)).create());
        treeGenerator.add("redwood_thin", 1, ((GeneratorRedwoodTreeThin.Builder)((GeneratorRedwoodTreeThin.Builder)new GeneratorRedwoodTreeThin.Builder().log(BOPWoods.REDWOOD)).leaves(BOPTrees.REDWOOD)).create());
        this.addGenerator("dead_leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).placeOn(BlockQueries.fertile)).with(BOPPlants.DEADLEAFPILE)).create());
        this.addGenerator("leaf_piles", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).placeOn(BlockQueries.fertile)).with(BOPPlants.LEAFPILE)).generationAttempts(64)).create());
        this.addGenerator("double_fern", GeneratorStage.FLOWERS, ((GeneratorDoubleFlora.Builder)new GeneratorDoubleFlora.Builder().amountPerChunk(8.0f)).with(BlockDoublePlant.EnumPlantType.FERN).create());
        this.addGenerator("brown_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.2f)).generationAttempts(16)).with(Blocks.field_150338_P.func_176223_P())).create());
        this.addGenerator("red_mushrooms", GeneratorStage.SHROOM, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.1f)).generationAttempts(16)).with(Blocks.field_150337_Q.func_176223_P())).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(8.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("fern", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.FERN)).create());
        this.addGenerator("amber", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.AMBER)).create());
    }
}

