/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.lib.util.StackHelper;
import net.silentchaos512.sgextraparts.SGExtraParts;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.init.ModItems;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartMisc implements IPartProperties
{
    SOULFORGED_STEEL("betterwithmods", "SoulforgedSteel", "ingot", EnumMaterialTier.SUPER, 0x646464, 3, 1564, 12.0f, 4.0f, 4.0f, 1.0f, 20, 16, 2.0f),
    FELDSPAR("sgextraparts", "feldspar", "", EnumMaterialTier.MUNDANE, 11562827, 1, 108, 5.0f, 2.0f, 0.0f, 1.0f, 10, 10, 1.0f);

    final String modId;
    final String name;
    final String orePrefix;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;
    final int harvestLevel;

    private EnumPartMisc(String modId, String name, String orePrefix, EnumMaterialTier tier, int color, int harvestLevel, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.modId = modId;
        this.name = name;
        this.orePrefix = orePrefix;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
        this.harvestLevel = harvestLevel;
    }

    public String getName() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", this.name + ".name", new Object[0]);
    }

    public String getNamePrefix() {
        return "";
    }

    public ItemStack getCraftingStack() {
        switch (this) {
            case SOULFORGED_STEEL: {
                return new ItemStack(Item.func_111206_d((String)"betterwithmods:material"), 1, 14);
            }
            case FELDSPAR: {
                return ModItems.generic.feldspar;
            }
        }
        return StackHelper.empty();
    }

    public String getCraftingOreName() {
        if (this.orePrefix.isEmpty()) {
            return "";
        }
        return this.orePrefix + this.name;
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartMisc part : EnumPartMisc.values()) {
            names.add(part.modId + "." + part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule("misc", names.toArray(new String[names.size()]), (Object[])EnumPartMisc.values());
        for (EnumPartMisc part : EnumPartMisc.values()) {
            if (!enabled[part.ordinal()] || !Loader.isModLoaded((String)part.modId)) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(part));
        }
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }
}

