/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.sgextraparts.SGExtraParts;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartExtreme implements IPartProperties
{
    REINFORCED_OBSIDIAN("ReinforcedObsidian", EnumMaterialTier.SUPER, 2883899, 3, 20480, 6.0f, 3.0f, 3.0f, 0.8f, 17, 14, 1.5f),
    CRYSTALLIZED_CHAOS("CrystallizedChaos", EnumMaterialTier.SUPER, 15316730, 6, 1024, 25.0f, 7.0f, 7.0f, 1.2f, 22, 30, 3.0f);

    final String name;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;
    final int harvestLevel;

    private EnumPartExtreme(String name, EnumMaterialTier tier, int color, int harvestLevel, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.name = name;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
        this.harvestLevel = harvestLevel;
    }

    public String getName() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", this.name + ".name", new Object[0]);
    }

    public String getNamePrefix() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", this.name + ".prefix", new Object[0]);
    }

    public ItemStack getCraftingStack() {
        switch (this) {
            case CRYSTALLIZED_CHAOS: {
                return ModItems.craftingMaterial.chaosEssenceCrystallized;
            }
            case REINFORCED_OBSIDIAN: {
                return net.silentchaos512.sgextraparts.init.ModItems.generic.reinforcedObsidian;
            }
        }
        SGExtraParts.logHelper.severe((Object)("EnumPartExtreme.getCraftingStack: unknown enum value " + (Object)((Object)this)));
        return null;
    }

    public String getCraftingOreName() {
        return "";
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartExtreme part : EnumPartExtreme.values()) {
            names.add(part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule("extreme_parts", names.toArray(new String[names.size()]), (Object[])EnumPartExtreme.values());
        for (EnumPartExtreme part : EnumPartExtreme.values()) {
            if (!enabled[part.ordinal()]) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(part));
        }
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }
}

