/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.sgextraparts.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.tool.part.IPartProperties;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.sgextraparts.SGExtraParts;
import net.silentchaos512.sgextraparts.config.ConfigExtraParts;
import net.silentchaos512.sgextraparts.lib.ToolPartSGEP;

public enum EnumPartBotania implements IPartProperties
{
    MANASTEEL("Manasteel", EnumMaterialTier.REGULAR, 4833515, 3, 300, 6.2f, 2.0f, 5.0f, 1.0f, 16, 20, 2.0f),
    ELEMENTIUM("Elementium", EnumMaterialTier.REGULAR, 16681983, 3, 720, 6.2f, 2.0f, 5.0f, 1.1f, 16, 20, 4.0f),
    TERRASTEEL("Terrasteel", EnumMaterialTier.SUPER, 10938186, 4, 2300, 9.0f, 3.0f, 7.0f, 1.0f, 20, 26, 2.0f);

    final String name;
    final int color;
    final EnumMaterialTier tier;
    final int durability;
    final float miningSpeed;
    final float meleeDamage;
    final float magicDamage;
    final float meleeSpeed;
    final int enchantability;
    final float chargeSpeed;
    final float protection;
    final int harvestLevel;

    private EnumPartBotania(String name, EnumMaterialTier tier, int color, int harvestLevel, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed) {
        this.name = name;
        this.color = color;
        this.tier = tier;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.chargeSpeed = chargeSpeed;
        this.protection = protection;
        this.harvestLevel = harvestLevel;
    }

    public String getName() {
        return SGExtraParts.localizationHelper.getLocalizedString("part", this.name + ".name", new Object[0]);
    }

    public String getNamePrefix() {
        return "";
    }

    public ItemStack getCraftingStack() {
        Item item = Item.func_111206_d((String)"botania:manaResource");
        return new ItemStack(item, 1, this == MANASTEEL ? 0 : (this == ELEMENTIUM ? 7 : 4));
    }

    public String getCraftingOreName() {
        switch (this) {
            case MANASTEEL: {
                return "ingotManasteel";
            }
            case ELEMENTIUM: {
                return "ingotElvenElementium";
            }
            case TERRASTEEL: {
                return "ingotTerrasteel";
            }
        }
        return "";
    }

    public static void registerToolParts() {
        ArrayList names = Lists.newArrayList();
        for (EnumPartBotania part : EnumPartBotania.values()) {
            names.add(part.name.toLowerCase());
        }
        boolean[] enabled = ConfigExtraParts.loadPartModule("botania", names.toArray(new String[names.size()]), (Object[])EnumPartBotania.values());
        for (EnumPartBotania part : EnumPartBotania.values()) {
            if (!enabled[part.ordinal()]) continue;
            ToolPartRegistry.putPart((ToolPart)new ToolPartSGEP(part));
        }
    }

    public int getColor() {
        return this.color;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getDurability() {
        return this.durability;
    }

    public float getMiningSpeed() {
        return this.miningSpeed;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    public float getProtection() {
        return this.protection;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }
}

