/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.world.location.BlockStateWrapper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public final class BlockStructure {
    private BlockStateWrapper[][][] structure;
    private List<ItemStack> allBlocks;
    private List<BlockStateWrapper> blockTypes;
    private final int hn;
    private final int length;
    private final int width;
    private final int height;

    public BlockStructure(int length, int width, int height, IStructureFiller data) {
        this.hn = Math.max(length, Math.max(width, height));
        this.length = length;
        this.width = width;
        this.height = height;
        this.structure = new BlockStateWrapper[length][width][height];
        this.allBlocks = Lists.newArrayList();
        this.blockTypes = Lists.newArrayList();
        HashMap allBlocks = Maps.newHashMap();
        for (int l = 0; l < length; ++l) {
            for (int w = 0; w < width; ++w) {
                for (int h = 0; h < height; ++h) {
                    BlockStateWrapper blockData = data.getBlockAtPos(l, w, h);
                    if (blockData != null && blockData.block != null) {
                        this.structure[l][w][h] = blockData;
                        if (allBlocks.get(blockData) == null) {
                            allBlocks.put(blockData, 0);
                        }
                        int i = (Integer)allBlocks.get(blockData);
                        allBlocks.remove(blockData);
                        allBlocks.put(blockData, ++i);
                        continue;
                    }
                    this.structure[l][w][h] = blockData;
                }
            }
        }
        for (BlockStateWrapper blockData : allBlocks.keySet()) {
            int i = (Integer)allBlocks.get(blockData);
            ItemStack stack = new ItemStack(blockData.block, i, blockData.meta);
            this.allBlocks.add(stack);
            this.blockTypes.add(blockData);
        }
    }

    public BlockStructure newBlockStructureWithSameDimensions(IStructureFiller structureFiller) {
        return new BlockStructure(this.length, this.width, this.height, structureFiller);
    }

    protected void startLoop(IPositionCall callable) {
        for (int l = 0; l < this.length; ++l) {
            for (int w = 0; w < this.width; ++w) {
                for (int h = 0; h < this.height; ++h) {
                    callable.forPos(l, w, h);
                }
            }
        }
    }

    public BlockStateWrapper[][][] getStructure() {
        return this.structure;
    }

    public List<ItemStack> getAllBlocks() {
        return this.allBlocks;
    }

    public List<BlockStateWrapper> getBlockTypes() {
        return this.blockTypes;
    }

    protected int getHn() {
        return this.hn;
    }

    public int getLength() {
        return this.length;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected static interface IPositionCall {
        public void forPos(int var1, int var2, int var3);
    }

    public static interface IStructureFiller {
        public BlockStateWrapper getBlockAtPos(int var1, int var2, int var3);
    }
}

