/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry.allele;

import elec332.core.compat.forestry.allele.AbstractAllele;
import elec332.core.compat.forestry.bee.ForestryBeeEffects;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IEffectData;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class AlleleEffect
extends AbstractAllele
implements IAlleleBeeEffect {
    private boolean combinable;

    public AlleleEffect(ResourceLocation rl) {
        super(rl, new IChromosomeType[]{EnumBeeChromosome.EFFECT});
    }

    public AlleleEffect(String s) {
        super(s, new IChromosomeType[]{EnumBeeChromosome.EFFECT});
    }

    public AlleleEffect(String uid, String unlocalizedName) {
        super(uid, unlocalizedName, new IChromosomeType[]{EnumBeeChromosome.EFFECT});
    }

    public AlleleEffect setCombinable() {
        this.combinable = true;
        return this;
    }

    public abstract IEffectData validateStorage(IEffectData var1);

    public abstract IEffectData doEffect(IBeeGenome var1, IEffectData var2, IBeeHousing var3);

    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        ForestryBeeEffects.effectNone.doFX(genome, storedData, housing);
        return storedData;
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public static AxisAlignedBB getBounding(IBeeGenome genome, IBeeHousing housing) {
        return forestry.apiculture.genetics.alleles.AlleleEffect.getBounding((IBeeGenome)genome, (IBeeHousing)housing);
    }

    public static <T extends Entity> List<T> getEntitiesInRange(IBeeGenome genome, IBeeHousing housing, Class<T> entityClass) {
        return forestry.apiculture.genetics.alleles.AlleleEffect.getEntitiesInRange((IBeeGenome)genome, (IBeeHousing)housing, entityClass);
    }
}

