/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.tesselator;

import elec332.core.api.client.ITessellator;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ElecTessellator
implements ITessellator {
    private Tessellator tessellator;
    private final BufferBuilder worldRenderer;
    private int brightness1;
    private int brightness2;
    private int color1;
    private int color2;
    private int color3;
    private int color4;

    public ElecTessellator() {
        this(Tessellator.func_178181_a());
    }

    public ElecTessellator(Tessellator tessellator) {
        this(tessellator.func_178180_c());
        this.tessellator = tessellator;
    }

    public ElecTessellator(BufferBuilder worldRenderer) {
        this.worldRenderer = worldRenderer;
    }

    @Override
    public void setBrightness(int brightness) {
        this.brightness1 = brightness >> 16 & 0xFFFF;
        this.brightness2 = brightness & 0xFFFF;
    }

    @Override
    public void setColorOpaque_F(float f1, float f2, float f3) {
        this.setColorOpaque((int)(f1 * 255.0f), (int)(f2 * 255.0f), (int)(f3 * 255.0f));
    }

    @Override
    public void setColorOpaque(int i1, int i2, int i3) {
        this.setColorRGBA(i1, i2, i3, 255);
    }

    @Override
    public void setColorRGBA_F(float f1, float f2, float f3, float f4) {
        this.setColorRGBA((int)(f1 * 255.0f), (int)(f2 * 255.0f), (int)(f3 * 255.0f), (int)(f4 * 255.0f));
    }

    @Override
    public void setColorRGBA_I(int color, int i2) {
        int k = color >> 16 & 0xFF;
        int l = color >> 8 & 0xFF;
        int i1 = color & 0xFF;
        this.setColorRGBA(k, l, i1, i2);
    }

    @Override
    public void setColorRGBA(int i1, int i2, int i3, int i4) {
        this.color1 = i1;
        this.color2 = i2;
        this.color3 = i3;
        this.color4 = i4;
    }

    public void startDrawingWorldBlock() {
        this.worldRenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
    }

    public void startDrawingGui() {
        this.worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
    }

    @Override
    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        this.worldRenderer.func_181662_b(x, y, z);
        this.drawColor();
        this.worldRenderer.func_187315_a(u, v);
        this.worldRenderer.func_187314_a(this.brightness1, this.brightness2);
        this.worldRenderer.func_181675_d();
    }

    @Override
    public Tessellator getMCTessellator() {
        if (this.tessellator == null) {
            throw new IllegalStateException();
        }
        return this.tessellator;
    }

    private void drawColor() {
        this.worldRenderer.func_181669_b(this.color1, this.color2, this.color3, this.color4);
    }
}

