/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.configuration;

import codechicken.lib.configuration.ConfigTag;
import codechicken.lib.util.ResourceUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class ConfigFile
extends ConfigTag {
    protected File file;
    protected boolean isLoading;

    public ConfigFile(File file) {
        this(file, true);
    }

    public ConfigFile(File file, boolean load) {
        this(file.getName(), file, load);
    }

    public ConfigFile(String prefix, File file, boolean load) {
        super(prefix, null);
        this.file = file;
        if (load) {
            this.load();
        }
    }

    public void load() {
        ResourceUtils.tryCreateFile(this.file);
        this.isLoading = true;
        this.clear();
        ConfigReader reader = null;
        try {
            reader = new ConfigReader(new FileReader(this.file));
            this.parseTag(reader);
        }
        catch (IOException e) {
            try {
                throw new ConfigException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                this.isLoading = false;
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        this.isLoading = false;
    }

    public void write(File file) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileOutputStream(file));
            for (String comment : this.comment) {
                this.writeLine(writer, 0, "#" + comment, new Object[0]);
            }
            this.writeTag(writer, 0);
        }
        catch (IOException e) {
            try {
                throw new ConfigException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    @Override
    public void save() {
        if (this.isDirty()) {
            this.write(this.file);
            this.onSave();
        }
    }

    public class ConfigException
    extends RuntimeException {
        public ConfigException() {
        }

        public ConfigException(String message) {
            super(message);
        }

        public ConfigException(Throwable throwable) {
            super(throwable);
        }

        public ConfigException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }

    protected class ConfigReader
    extends BufferedReader {
        private int line;

        public ConfigReader(Reader in, int sz) {
            super(in, sz);
        }

        public ConfigReader(Reader in) {
            super(in);
        }

        @Override
        public String readLine() throws IOException {
            ++this.line;
            return super.readLine();
        }

        public int getCurrLine() {
            return this.line;
        }
    }
}

