/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.commands;

import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandTools {
    public static boolean isOp(ICommandSender sender) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
            return true;
        }
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = sender.func_130014_f_().func_72924_a(sender.func_70005_c_());
            UserListOpsEntry userentry = (UserListOpsEntry)((EntityPlayerMP)player).field_71133_b.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
            return userentry != null && userentry.func_152644_a() >= 4;
        }
        if (sender instanceof TileEntityCommandBlock) {
            return true;
        }
        return true;
    }

    public static ITextComponent makeError(String text) {
        return CommandTools.makeTranslatedMessage(text, "red:italic", new Object[0]);
    }

    public static ITextComponent makeTranslatedMessage(String key, String formatting, Object ... args) {
        if (formatting == null) {
            formatting = "";
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof String) {
                args[i] = new TextComponentTranslation((String)args[i], new Object[0]);
            }
            if (formatting.isEmpty() || !(args[i] instanceof ITextComponent)) continue;
            ITextComponent component = (ITextComponent)args[i];
            String[] args2 = formatting.split(":");
            String colour = args2[0].toUpperCase(Locale.ENGLISH);
            component.func_150256_b().func_150238_a(TextFormatting.func_96300_b((String)colour));
            if (args2.length <= 1) continue;
            for (int i1 = 1; i1 < args2.length; ++i1) {
                String arg = args2[i1];
                if (arg.equalsIgnoreCase("italic")) {
                    component.func_150256_b().func_150217_b(Boolean.valueOf(true));
                }
                if (arg.equalsIgnoreCase("bold")) {
                    component.func_150256_b().func_150227_a(Boolean.valueOf(true));
                }
                if (arg.equalsIgnoreCase("underlined")) {
                    component.func_150256_b().func_150228_d(Boolean.valueOf(true));
                }
                if (arg.equalsIgnoreCase("strikethrough")) {
                    component.func_150256_b().func_150225_c(Boolean.valueOf(true));
                }
                if (!arg.equalsIgnoreCase("obfuscated")) continue;
                component.func_150256_b().func_150237_e(Boolean.valueOf(true));
            }
        }
        TextComponentTranslation translated = new TextComponentTranslation(key, args);
        return translated;
    }

    public static void sendBadArgumentsMissingArg(ICommandSender sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.invalidmissing"));
    }

    public static void sendBadArgumentsTryTab(ICommandSender sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.invalidtab"));
    }

    public static void sendError(ICommandSender sender, String text) {
        sender.func_145747_a(CommandTools.makeError(text));
    }

    public static void sendMessage(ICommandSender sender, String text) {
        ITextComponent message = CommandTools.makeTranslatedMessage(text, null, new Object[0]);
        sender.func_145747_a(message);
    }

    public static void sendNoPermissions(ICommandSender sender) {
        sender.func_145747_a(CommandTools.makeError("pokecube.command.noperms"));
    }
}

