/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.blockentity.IBlockEntity;

@SideOnly(value=Side.CLIENT)
public class RenderBlockEntity<T extends EntityLivingBase>
extends RenderLivingBase<T> {
    private static IBakedModel crate_model;
    float pitch = 0.0f;
    float yaw = 0.0f;
    long time = 0L;
    boolean up = true;
    static final Tessellator t;
    BufferBuilder b = t.func_178180_c();
    ResourceLocation texture;

    public RenderBlockEntity(RenderManager manager) {
        super(manager, null, 0.0f);
    }

    public void func_76986_a(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        try {
            int k;
            int j;
            int i;
            this.b = Tessellator.func_178181_a().func_178180_c();
            IBlockEntity blockEntity = (IBlockEntity)entity;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            if (entity instanceof IMultiplePassengerEntity) {
                IMultiplePassengerEntity multi = (IMultiplePassengerEntity)entity;
                float yaw = -(multi.getPrevYaw() + (multi.getYaw() - multi.getPrevYaw()) * partialTicks);
                float pitch = -(multi.getPrevPitch() + (multi.getPitch() - multi.getPrevPitch()) * partialTicks);
                GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int xMin = MathHelper.func_76128_c((double)((double)blockEntity.getMin().func_177958_n() + ((EntityLivingBase)entity).field_70165_t));
            int zMin = MathHelper.func_76128_c((double)((double)blockEntity.getMin().func_177952_p() + ((EntityLivingBase)entity).field_70161_v));
            int xMax = MathHelper.func_76128_c((double)((double)blockEntity.getMax().func_177958_n() + ((EntityLivingBase)entity).field_70165_t));
            int zMax = MathHelper.func_76128_c((double)((double)blockEntity.getMax().func_177952_p() + ((EntityLivingBase)entity).field_70161_v));
            int yMin = (int)Math.round((double)blockEntity.getMin().func_177956_o() + ((EntityLivingBase)entity).field_70163_u);
            int yMax = (int)Math.round((double)blockEntity.getMax().func_177956_o() + ((EntityLivingBase)entity).field_70163_u);
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        pos.func_181079_c(i, j, k);
                        if (!blockEntity.shouldHide((BlockPos)pos)) {
                            this.drawBlockAt((BlockPos)pos, blockEntity);
                            continue;
                        }
                        this.drawCrateAt(pos, blockEntity);
                    }
                }
            }
            for (i = xMin; i <= xMax; ++i) {
                for (j = yMin; j <= yMax; ++j) {
                    for (k = zMin; k <= zMax; ++k) {
                        pos.func_181079_c(i, j, k);
                        if (blockEntity.shouldHide((BlockPos)pos)) continue;
                        this.drawTileAt((BlockPos)pos, blockEntity, partialTicks);
                    }
                }
            }
            GL11.glPopMatrix();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawCrateAt(BlockPos.MutableBlockPos pos, IBlockEntity blockEntity) {
        BlockPos origin = ((Entity)blockEntity).func_180425_c();
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(-origin.func_177958_n()), (double)(0.5 - (double)origin.func_177956_o()), (double)(-origin.func_177952_p()));
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        RenderHelper.func_74518_a();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        float f7 = 1.0f;
        GlStateManager.func_179152_a((float)(-f7), (float)(-f7), (float)f7);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        IBakedModel model = this.getCrateModel();
        this.renderBakedBlockModel(blockEntity, model, Blocks.field_150348_b.func_176223_P(), (IBlockAccess)blockEntity.getFakeWorld(), (BlockPos)pos);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    private IBakedModel getCrateModel() {
        if (crate_model == null) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)new ResourceLocation("thutcore", "block/craft_crate"), (String)"derp?");
            crate_model = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
        }
        return crate_model;
    }

    private void drawBlockAt(BlockPos pos, IBlockEntity entity) {
        IBlockState iblockstate = entity.getFakeWorld().func_180495_p(pos);
        if (iblockstate.func_185904_a() != Material.field_151579_a) {
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            IBlockState actualstate = iblockstate.func_185899_b((IBlockAccess)entity.getFakeWorld(), pos);
            if ((iblockstate = actualstate.func_177230_c().getExtendedState(actualstate, (IBlockAccess)entity.getFakeWorld(), pos)).func_185901_i() == EnumBlockRenderType.MODEL) {
                BlockPos liftPos = ((Entity)entity).func_180425_c();
                GlStateManager.func_179094_E();
                GL11.glTranslated((double)(-liftPos.func_177958_n()), (double)(0.5 - (double)liftPos.func_177956_o()), (double)(-liftPos.func_177952_p()));
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                RenderHelper.func_74518_a();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179147_l();
                GlStateManager.func_179129_p();
                if (Minecraft.func_71379_u()) {
                    GlStateManager.func_179103_j((int)7425);
                } else {
                    GlStateManager.func_179103_j((int)7424);
                }
                float f7 = 1.0f;
                GlStateManager.func_179152_a((float)(-f7), (float)(-f7), (float)f7);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                IBakedModel model = blockrendererdispatcher.func_184389_a(actualstate);
                this.renderBakedBlockModel(entity, model, iblockstate, (IBlockAccess)entity.getFakeWorld(), pos);
                RenderHelper.func_74519_b();
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderBakedBlockModel(IBlockEntity entity, IBakedModel model, IBlockState state, IBlockAccess world, BlockPos pos) {
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_187498_b((IBlockAccess)entity.getFakeWorld().world, model, state, pos, buffer, false, 0L);
        tessellator.func_78381_a();
    }

    private void drawTileAt(BlockPos pos, IBlockEntity entity, float partialTicks) {
        TileEntity tile = entity.getFakeWorld().func_175625_s(pos);
        if (tile != null) {
            GL11.glPushMatrix();
            BlockPos liftPos = ((Entity)entity).func_180425_c();
            GL11.glTranslated((double)(pos.func_177958_n() - liftPos.func_177958_n()), (double)((double)pos.func_177956_o() + 0.5 - (double)liftPos.func_177956_o()), (double)(pos.func_177952_p() - liftPos.func_177952_p()));
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float f7 = 1.0f;
            GlStateManager.func_179152_a((float)(-f7), (float)(-f7), (float)f7);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean fast = tile.hasFastRenderer();
            if (fast) {
                TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, 0.0, 0.0, 0.0, partialTicks);
                TileEntityRendererDispatcher.field_147556_a.drawBatch(0);
                TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, 0.0, 0.0, 0.0, partialTicks);
                TileEntityRendererDispatcher.field_147556_a.drawBatch(1);
            } else {
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, 0.0, 0.0, 0.0, partialTicks);
            }
            GlStateManager.func_179121_F();
            GL11.glPopMatrix();
        }
    }

    public boolean shouldRender(T entityIn, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return null;
    }

    static {
        t = new Tessellator(0x200000);
    }
}

