/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHealthStore;
import sonar.calculator.mod.api.nutrition.IHungerStore;
import sonar.calculator.mod.client.gui.misc.GuiAlgorithmAssimilator;
import sonar.calculator.mod.client.gui.misc.GuiStoneAssimilator;
import sonar.calculator.mod.common.block.CalculatorLeaves;
import sonar.calculator.mod.common.block.CalculatorLogs;
import sonar.calculator.mod.common.containers.ContainerAlgorithmAssimilator;
import sonar.calculator.mod.common.containers.ContainerAssimilator;
import sonar.calculator.mod.common.recipes.TreeHarvestRecipes;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.utils.BlockCoords;
import sonar.core.common.block.properties.SonarProperties;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.NBTHelper;

public abstract class TileEntityAssimilator
extends TileEntityInventory
implements IFlexibleGui {
    public boolean hasTree;
    public Random rand = new Random();
    public int tickRate = 30;
    public int tick;

    public abstract boolean harvestBlock(BlockCoords var1);

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isClient()) {
            return;
        }
        if (this.tick != this.tickRate) {
            ++this.tick;
        } else {
            List<BlockCoords> leaves;
            if (this instanceof Algorithm) {
                EnumFacing dir = EnumFacing.func_82600_a((int)this.func_145832_p());
                IItemHandler handler = ItemTransferHelper.getItemHandlerOffset((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)dir);
                ItemTransferHelper.doSimpleTransfer((Iterable)Lists.newArrayList((Object[])new IItemHandler[]{handler}), (Iterable)Lists.newArrayList((Object[])new IItemHandler[]{this.inv().getItemHandler(dir)}), IS -> true, (int)32);
            }
            this.tick = 0;
            this.hasTree = this.hasTree();
            if (this.hasTree && (leaves = this.getLeaves()) != null && leaves.size() != 0) {
                for (BlockCoords coords : leaves) {
                    if (!this.harvestBlock(coords)) continue;
                    return;
                }
            }
        }
    }

    public boolean hasTree() {
        EnumFacing dir = ((EnumFacing)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)SonarProperties.FACING)).func_176734_d();
        boolean flag = true;
        for (int log = 0; log < 3; ++log) {
            this.field_174879_c.func_177972_a(dir).func_177982_a(0, log, 0);
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir).func_177982_a(0, log, 0)).func_177230_c() instanceof CalculatorLogs) continue;
            flag = false;
        }
        int leafCount = 0;
        for (int X = -3; X < 3; ++X) {
            for (int Z = -3; Z < 3; ++Z) {
                for (int leaves = 1; leaves < 8; ++leaves) {
                    if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir).func_177982_a(X, leaves, Z)).func_177230_c() instanceof CalculatorLeaves) continue;
                    ++leafCount;
                }
            }
        }
        if (leafCount < 10) {
            flag = false;
        }
        return flag;
    }

    public List<BlockCoords> getLeaves() {
        EnumFacing dir = ((EnumFacing)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)SonarProperties.FACING)).func_176734_d();
        ArrayList<BlockCoords> leafList = new ArrayList<BlockCoords>();
        for (int X = -2; X < 3; ++X) {
            for (int Z = -2; Z < 3; ++Z) {
                for (int leaves = 1; leaves < 8; ++leaves) {
                    BlockPos pos = this.field_174879_c.func_177972_a(dir).func_177982_a(X, leaves, Z);
                    if (!(this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof CalculatorLeaves)) continue;
                    leafList.add(new BlockCoords(pos));
                }
            }
        }
        return leafList;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.tick = nbt.func_74762_e("tick");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74768_a("tick", this.tick);
        }
        return nbt;
    }

    public static class Algorithm
    extends TileEntityAssimilator {
        public Algorithm() {
            this.inv.setSize(27);
            this.inv.default_external_insert_result = false;
            this.inv.default_external_extract_result = true;
        }

        @Override
        public boolean harvestBlock(BlockCoords block) {
            IBlockState state = block.getBlockState(this.field_145850_b);
            if (((CalculatorLeaves.LeafGrowth)((Object)state.func_177229_b(CalculatorLeaves.GROWTH))).getMeta() > 2) {
                ArrayList<ItemStack> stacks = TreeHarvestRecipes.harvestLeaves(this.field_145850_b, block.getBlockPos(), this.rand.nextBoolean());
                for (ItemStack stack : stacks) {
                    if (stack.func_190926_b() || (stack = ItemHandlerHelper.insertItem((IItemHandler)this.inv(), (ItemStack)stack, (boolean)false)).func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
                }
                return true;
            }
            return false;
        }

        public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new ContainerAlgorithmAssimilator(player, this);
        }

        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiAlgorithmAssimilator(player, this);
        }
    }

    public static class Stone
    extends TileEntityAssimilator {
        public int healthPoints;
        public int hungerPoints;
        public int speed = 4;

        public Stone() {
            this.inv.setSize(1);
            this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)0, s -> s.func_77973_b() instanceof IHungerStore || s.func_77973_b() instanceof IHealthStore), EnumFilterType.INTERNAL);
        }

        @Override
        public void func_73660_a() {
            super.func_73660_a();
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            this.chargeHunger((ItemStack)this.slots().get(0));
            this.chargeHealth((ItemStack)this.slots().get(0));
        }

        @Override
        public boolean harvestBlock(BlockCoords coords) {
            CalculatorLeaves.LeafGrowth growth;
            IBlockState state = coords.getBlockState(this.field_145850_b);
            if (!(state.func_177230_c() != Calculator.tanzaniteLeaves && state.func_177230_c() != Calculator.amethystLeaves || (growth = (CalculatorLeaves.LeafGrowth)((Object)state.func_177229_b(CalculatorLeaves.GROWTH))) != CalculatorLeaves.LeafGrowth.MATURED && growth != CalculatorLeaves.LeafGrowth.READY)) {
                if (state.func_177230_c() == Calculator.tanzaniteLeaves) {
                    ++this.healthPoints;
                    this.field_145850_b.func_175656_a(coords.getBlockPos(), state.func_177226_a(CalculatorLeaves.GROWTH, (Comparable)((Object)CalculatorLeaves.LeafGrowth.FRESH)));
                    return true;
                }
                if (state.func_177230_c() == Calculator.amethystLeaves) {
                    ++this.hungerPoints;
                    this.field_145850_b.func_175656_a(coords.getBlockPos(), state.func_177226_a(CalculatorLeaves.GROWTH, (Comparable)((Object)CalculatorLeaves.LeafGrowth.FRESH)));
                    return true;
                }
            }
            return false;
        }

        public void chargeHunger(ItemStack stack) {
            int max;
            IHungerStore module;
            int hunger;
            if (!stack.func_190926_b() && this.hungerPoints != 0 && stack.func_77973_b() instanceof IHungerStore && ((hunger = (module = (IHungerStore)stack.func_77973_b()).getHungerPoints(stack)) < (max = module.getMaxHungerPoints(stack)) || max == -1)) {
                if (this.hungerPoints >= this.speed) {
                    if (max == -1 || max >= hunger + this.speed) {
                        module.transferHunger(this.speed, stack, ProcessType.ADD);
                        this.hungerPoints -= this.speed;
                    } else {
                        module.transferHunger(max - hunger, stack, ProcessType.ADD);
                        this.hungerPoints -= max - hunger;
                    }
                } else if (this.hungerPoints <= this.speed) {
                    if (max == -1 | max >= hunger + this.speed) {
                        module.transferHunger(this.speed, stack, ProcessType.ADD);
                        this.hungerPoints = 0;
                    } else {
                        module.transferHunger(max - hunger, stack, ProcessType.ADD);
                        this.hungerPoints = this.hungerPoints - max - hunger;
                    }
                }
            }
        }

        public void chargeHealth(ItemStack stack) {
            int max;
            IHealthStore module;
            int health;
            if (!stack.func_190926_b() && this.healthPoints != 0 && stack.func_77973_b() instanceof IHealthStore && ((health = (module = (IHealthStore)stack.func_77973_b()).getHealthPoints(stack)) < (max = module.getMaxHealthPoints(stack)) || max == -1)) {
                if (this.healthPoints >= this.speed) {
                    if (max == -1 || max >= health + this.speed) {
                        module.transferHealth(this.speed, stack, ProcessType.ADD);
                        this.healthPoints -= this.speed;
                    } else {
                        module.transferHealth(max - health, stack, ProcessType.ADD);
                        this.healthPoints -= max - health;
                    }
                } else if (this.healthPoints <= this.speed) {
                    if (max == -1 | max >= health + this.speed) {
                        module.transferHealth(this.speed, stack, ProcessType.ADD);
                        this.healthPoints = 0;
                    } else {
                        module.transferHealth(max - health, stack, ProcessType.ADD);
                        this.healthPoints = this.healthPoints - max - health;
                    }
                }
            }
        }

        @Override
        public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
            super.readData(nbt, type);
            this.healthPoints = nbt.func_74762_e("health");
            this.hungerPoints = nbt.func_74762_e("hunger");
            if (type != NBTHelper.SyncType.DROP) {
                this.hasTree = nbt.func_74767_n("hasTree");
            }
        }

        @Override
        public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
            super.writeData(nbt, type);
            nbt.func_74768_a("health", this.healthPoints);
            nbt.func_74768_a("hunger", this.hungerPoints);
            if (type != NBTHelper.SyncType.DROP) {
                nbt.func_74757_a("hasTree", this.hasTree);
            }
            return nbt;
        }

        public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new ContainerAssimilator(player.field_71071_by, this);
        }

        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiStoneAssimilator(player.field_71071_by, this);
        }
    }
}

