/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.tileentity.machines.TileEntityPowerCube;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.handlers.energy.EnergyTransferHandler;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.utils.IMachineSides;
import sonar.core.utils.MachineSideConfig;
import sonar.core.utils.MachineSides;

public class TileEntityAdvancedPowerCube
extends TileEntityPowerCube
implements IFlexibleGui,
IMachineSides {
    public MachineSides sides = new MachineSides(MachineSideConfig.INPUT, (TileEntity)this, new Object[]{MachineSideConfig.NONE});

    public TileEntityAdvancedPowerCube() {
        this.syncList.addParts(new IDirtyPart[]{this.sides});
        this.storage.setCapacity(CalculatorConfig.ADVANCED_POWER_CUBE_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.ADVANCED_POWER_CUBE_TRANSFER_RATE);
        this.CHARGING_RATE = CalculatorConfig.ADVANCED_POWER_CUBE_CHARGING_RATE;
        this.energyMode = EnergyMode.SEND_RECIEVE;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isClient()) {
            return;
        }
        this.addEnergy();
    }

    public void addEnergy() {
        if (this.storage.getEnergyStored() == 0) {
            return;
        }
        ArrayList facing = this.sides.getSidesWithConfig(MachineSideConfig.OUTPUT);
        if (!facing.isEmpty()) {
            EnergyTransferHandler.INSTANCE_SC.transferToAdjacent((TileEntity)this, (Iterable)facing, this.storage.getMaxExtract());
        }
    }

    public EnergyMode getModeForSide(EnumFacing side) {
        if (side != null) {
            return this.sides.getSideConfig(side).isInput() ? EnergyMode.RECIEVE : (this.sides.getSideConfig(side).isOutput() ? EnergyMode.SEND : EnergyMode.BLOCKED);
        }
        return super.getModeForSide(side);
    }

    public MachineSides getSideConfigs() {
        return this.sides;
    }
}

