/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.generators.GuiConductorMast;
import sonar.calculator.mod.common.containers.ContainerConductorMast;
import sonar.calculator.mod.common.recipes.ConductorMastRecipes;
import sonar.calculator.mod.common.tileentity.machines.TileEntityTransmitter;
import sonar.calculator.mod.common.tileentity.machines.TileEntityWeatherStation;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.machines.IProcessMachine;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.recipes.DefaultSonarRecipe;
import sonar.core.recipes.RecipeHelperV2;

public class TileEntityConductorMast
extends TileEntityEnergyInventory
implements IProcessMachine,
IFlexibleGui {
    public final SyncTagType.INT cookTime = new SyncTagType.INT(0);
    public final SyncTagType.INT lightningSpeed = new SyncTagType.INT(1);
    public final SyncTagType.INT lightTicks = new SyncTagType.INT(2);
    public final SyncTagType.INT lightingTicks = new SyncTagType.INT(3);
    public final SyncTagType.INT random = new SyncTagType.INT(4);
    public final SyncTagType.INT rfPerStrike = new SyncTagType.INT(5);
    public final SyncTagType.DOUBLE rfPerTick = new SyncTagType.DOUBLE(6);
    public int energyUsage;
    public int lastStations;
    public int strikes;
    public int avgTicks;
    public Random rand = new Random();

    public TileEntityConductorMast() {
        this.storage.setCapacity(CalculatorConfig.CONDUCTOR_MAST_STORAGE);
        this.storage.setMaxTransfer(CalculatorConfig.CONDUCTOR_MAST_TRANSFER_RATE);
        this.CHARGING_RATE = CalculatorConfig.CONDUCTOR_MAST_CHARGING_RATE;
        this.energyMode = EnergyMode.SEND;
        this.inv.setSize(2);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> SLOT == 0 && ConductorMastRecipes.instance().isValidInput(STACK), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getExtractFilters().put((SLOT, COUNT, FACE) -> SLOT == 1, EnumFilterType.EXTERNAL);
        this.syncList.addParts(new IDirtyPart[]{this.cookTime, this.lightingTicks, this.lightTicks, this.lightningSpeed, this.random, this.rfPerStrike, this.rfPerTick});
    }

    public DefaultSonarRecipe.Value getRecipe(ItemStack stack) {
        return (DefaultSonarRecipe.Value)ConductorMastRecipes.instance().getRecipeFromInputs(null, new Object[]{stack});
    }

    public void onLoaded() {
        TileEntityConductorMast.setWeatherStationAngles(true, this.field_145850_b, this.field_174879_c);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if ((Integer)this.cookTime.getObject() > 0) {
            this.cookTime.increaseBy(1);
        }
        if (this.canCook()) {
            if ((Integer)this.cookTime.getObject() == 0) {
                this.cookTime.increaseBy(1);
            }
            if ((Integer)this.cookTime.getObject() >= CalculatorConfig.CONDUCTOR_MAST_SPEED) {
                this.cookTime.setObject((Object)0);
                this.cookItem();
            }
        } else {
            this.cookTime.setObject((Object)0);
        }
        if (this.storage.getMaxEnergyStored() != this.storage.getEnergyStored() && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored() && (Integer)this.lightningSpeed.getObject() == 0) {
            this.random.setObject((Object)((int)(Math.random() * 9.0)));
            this.lightningSpeed.setObject((Object)(this.rand.nextInt(300) + this.getNextTime()));
        }
        if ((Integer)this.lightningSpeed.getObject() > 0) {
            if ((Integer)this.lightingTicks.getObject() >= (Integer)this.lightningSpeed.getObject()) {
                int lastSpeed = (Integer)this.lightningSpeed.getObject();
                this.lightingTicks.setObject((Object)0);
                this.lightningSpeed.setObject((Object)0);
                this.strikes = this.getStrikes();
                if (this.isClient()) {
                    for (int currentstrikes = this.strikes > 5 ? 5 : this.strikes; currentstrikes != 0; --currentstrikes) {
                        this.field_145850_b.func_72838_d((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 4), (double)this.field_174879_c.func_177952_p(), true));
                    }
                }
                this.lastStations = this.getStations();
                this.lightTicks.increaseBy(1);
                if (this.isServer()) {
                    this.rfPerStrike.setObject((Object)((CalculatorConfig.CONDUCTOR_MAST_PER_TICK / 200 + this.lastStations * CalculatorConfig.WEATHER_STATION_PER_TICK / 200) * this.strikes * 4 * 200));
                    this.rfPerTick.setObject((Object)((double)((Integer)this.rfPerStrike.getObject()).intValue() / (double)lastSpeed));
                }
            } else {
                this.lightingTicks.increaseBy(1);
            }
        }
        if ((Integer)this.lightTicks.getObject() > 0) {
            int add = (CalculatorConfig.CONDUCTOR_MAST_PER_TICK / 200 + this.lastStations * CalculatorConfig.WEATHER_STATION_PER_TICK / 200) * this.strikes * 4;
            if ((Integer)this.lightTicks.getObject() < 200) {
                if (this.storage.getEnergyStored() + add <= this.storage.getMaxEnergyStored()) {
                    this.lightTicks.increaseBy(1);
                    this.storage.receiveEnergy(add, false);
                } else {
                    this.lightTicks.increaseBy(1);
                    this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
                }
            } else if (this.storage.getEnergyStored() + add <= this.storage.getMaxEnergyStored()) {
                this.lightTicks.setObject((Object)0);
                this.storage.receiveEnergy(add, false);
            } else {
                this.lightTicks.increaseBy(1);
                this.storage.setEnergyStored(this.storage.getMaxEnergyStored());
            }
        }
        this.addEnergy(new EnumFacing[]{EnumFacing.DOWN});
        this.func_70296_d();
    }

    private void lightningStrike(World world, int x, int y, int z) {
        if (this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
            world.func_72838_d((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z, true));
        }
    }

    public boolean canCook() {
        ItemStack toCook = (ItemStack)this.slots().get(0);
        if (this.storage.getEnergyStored() == 0 || toCook.func_190926_b()) {
            return false;
        }
        if ((Integer)this.cookTime.getObject() >= CalculatorConfig.CONDUCTOR_MAST_SPEED) {
            return true;
        }
        DefaultSonarRecipe.Value recipe = this.getRecipe(toCook);
        if (recipe == null) {
            return false;
        }
        ItemStack stack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)0);
        ItemStack outputStack = (ItemStack)this.slots().get(1);
        if (!outputStack.func_190926_b()) {
            if (!outputStack.func_77969_a(stack)) {
                return false;
            }
            if (outputStack.func_190916_E() + stack.func_190916_E() > outputStack.func_77976_d()) {
                return false;
            }
        }
        this.energyUsage = recipe.getValue();
        if ((Integer)this.cookTime.getObject() == 0) {
            return this.storage.getEnergyStored() >= this.energyUsage;
        }
        return true;
    }

    private void cookItem() {
        ItemStack inputStack = (ItemStack)this.slots().get(0);
        DefaultSonarRecipe.Value recipe = this.getRecipe(inputStack);
        if (recipe == null) {
            return;
        }
        ItemStack stack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)0);
        this.energyUsage = recipe.getValue();
        this.storage.extractEnergy(this.energyUsage, false);
        ItemStack outputStack = (ItemStack)this.slots().get(1);
        if (outputStack.func_190926_b()) {
            this.slots().set(1, stack.func_77946_l());
        } else if (outputStack.func_77969_a(stack)) {
            outputStack.func_190917_f(1);
        }
        inputStack.func_190918_g(1);
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.lastStations = nbt.func_74762_e("lastStations");
            this.strikes = nbt.func_74762_e("strikes");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74768_a("lastStations", this.lastStations);
            nbt.func_74768_a("strikes", this.strikes);
        }
        return nbt;
    }

    public EnergyMode getModeForSide(EnumFacing side) {
        if (side == null) {
            return EnergyMode.SEND_RECIEVE;
        }
        if (side == EnumFacing.DOWN) {
            return EnergyMode.SEND;
        }
        return EnergyMode.BLOCKED;
    }

    public static void setWeatherStationAngles(boolean packet, World world, BlockPos pos) {
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                TileEntity target = world.func_175625_s(pos.func_177982_a(x, 0, z));
                if (!(target instanceof TileEntityWeatherStation)) continue;
                TileEntityWeatherStation station = (TileEntityWeatherStation)target;
                station.setAngle();
                station.markBlockForUpdate();
            }
        }
    }

    public int getStations() {
        int stations = 0;
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(x, 0, z));
                if (!(target instanceof TileEntityWeatherStation)) continue;
                TileEntityWeatherStation station = (TileEntityWeatherStation)target;
                if (station.x != this.field_174879_c.func_177958_n() || station.z != this.field_174879_c.func_177952_p()) continue;
                ++stations;
            }
        }
        return stations;
    }

    public int getStrikes() {
        int trans = this.getTransmitters();
        if (trans != 0) {
            if (trans > 9) {
                return trans / 4;
            }
            return 1;
        }
        return 1;
    }

    public int getNextTime() {
        int trans = this.getTransmitters();
        if (trans != 0) {
            if (trans > 9) {
                return 250;
            }
            return 1500 - 135 * trans;
        }
        return 1500;
    }

    public int getTransmitters() {
        int transmitter = 0;
        for (int x = -20; x <= 20; ++x) {
            for (int z = -20; z <= 20; ++z) {
                TileEntity target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(x, 0, z));
                if (!(target instanceof TileEntityTransmitter)) continue;
                TileEntityTransmitter station = (TileEntityTransmitter)target;
                ++transmitter;
            }
        }
        return transmitter;
    }

    public int getCurrentProcessTime() {
        return (Integer)this.cookTime.getObject();
    }

    public int getProcessTime() {
        return this.getBaseProcessTime();
    }

    public double getEnergyUsage() {
        return this.energyUsage;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerConductorMast(player.field_71071_by, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new GuiConductorMast(player.field_71071_by, this);
    }

    public int getBaseProcessTime() {
        return CalculatorConfig.CONDUCTOR_MAST_SPEED;
    }

    public boolean maxRender() {
        return true;
    }
}

