/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.modules;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.utils.ActionType;
import sonar.core.common.item.SonarEnergyItem;
import sonar.core.helpers.FontHelper;

public class BaseTerrainModule
extends SonarEnergyItem {
    public Block[] replacable;
    public final int usage;

    public BaseTerrainModule(int capacity, int usage) {
        super(capacity, capacity, capacity);
        this.usage = usage;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag par4) {
        super.func_77624_a(stack, world, list, par4);
        if (stack.func_77942_o()) {
            list.add(FontHelper.translate((String)"calc.mode") + ": " + this.currentBlockString(stack, world));
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.incrementMode(stack);
            FontHelper.sendMessage((String)this.currentBlockString(stack, player), (World)world, (EntityPlayer)player);
        } else if (this.canReplace(stack, world, pos)) {
            if (player.field_71075_bZ.field_75098_d || this.getEnergyLevel(stack) >= (long)this.usage) {
                world.func_175656_a(pos, this.getCurrentBlock(stack).func_176203_a(stack.func_77960_j()));
                if (!player.field_71075_bZ.field_75098_d) {
                    this.removeEnergy(stack, this.usage, ActionType.PERFORM);
                }
            } else {
                FontHelper.sendMessage((String)FontHelper.translate((String)"energy.noEnergy"), (World)world, (EntityPlayer)player);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public String currentBlockString(ItemStack stack, EntityPlayer player) {
        return new ItemStack(this.getCurrentBlock(stack), 1).func_82833_r();
    }

    public String currentBlockString(ItemStack stack, World world) {
        return new ItemStack(this.getCurrentBlock(stack), 1).func_82833_r();
    }

    public Block getCurrentBlock(ItemStack stack) {
        return this.replacable[this.getCurrentMode(stack)];
    }

    public int getCurrentMode(ItemStack stack) {
        NBTTagCompound nbtData;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbtData = stack.func_77978_p()) == null) {
            stack.func_77978_p().func_74768_a("Mode", 0);
        }
        return stack.func_77978_p().func_74762_e("Mode");
    }

    public void incrementMode(ItemStack stack) {
        int current = this.getCurrentMode(stack);
        if (current + 1 != this.replacable.length) {
            stack.func_77978_p().func_74768_a("Mode", current + 1);
        } else {
            stack.func_77978_p().func_74768_a("Mode", 0);
        }
    }

    public boolean canReplace(ItemStack stack, World world, BlockPos pos) {
        if (this.getCurrentBlock(stack) == world.func_180495_p(pos).func_177230_c()) {
            return false;
        }
        return this.replaceableBlock(world.func_180495_p(pos).func_177230_c());
    }

    public boolean replaceableBlock(Block block) {
        for (Block aReplacable : this.replacable) {
            if (aReplacable == null || block != aReplacable) continue;
            return true;
        }
        return false;
    }
}

