/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.particles;

import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class WolfIdleParticle
extends Particle {
    private static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("mobtotems:textures/particles/spirit_wolf_smoke.png");
    private static Queue<WolfIdleParticle> queuedRenders = new LinkedList<WolfIdleParticle>();
    private float partialTicks;
    private float rotationX;
    private float rotationZ;
    private float rotationYZ;
    private float rotationXZ;
    private float rotationXY;
    private static final int numFrames = 2;

    public WolfIdleParticle(World worldIn, double posXIn, double posYIn, double posZIn) {
        super(worldIn, posXIn, posYIn, posZIn);
        this.field_70545_g = 0.06f;
        this.field_70547_e = (int)(8.0f / (this.field_187136_p.nextFloat() * 0.9f + 0.1f));
    }

    public WolfIdleParticle(World worldIn, double posXIn, double posYIn, double posZIn, double speedXIn, double speedYIn, double speedZIn) {
        this(worldIn, posXIn, posYIn, posZIn);
        this.field_187129_i = speedXIn;
        this.field_187130_j = speedYIn;
        this.field_187131_k = speedZIn;
    }

    public void func_189213_a() {
        super.func_189213_a();
        float cappedParticleAge = this.field_70546_d > this.field_70547_e ? (float)this.field_70547_e : (float)this.field_70546_d;
        float particleTime = cappedParticleAge / (float)this.field_70547_e;
        int curFrame = (int)Math.floor(particleTime * 2.0f);
        this.func_70536_a(curFrame);
    }

    public void func_70536_a(int particleTextureIndex) {
        this.field_94054_b = particleTextureIndex;
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        this.partialTicks = partialTicks;
        this.rotationX = rotationX;
        this.rotationZ = rotationZ;
        this.rotationYZ = rotationYZ;
        this.rotationXZ = rotationXZ;
        this.rotationXY = rotationXY;
        queuedRenders.add(this);
    }

    public int func_70537_b() {
        return 1;
    }

    static void RenderQueuedRenders(Tessellator tessellator) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(PARTICLE_TEXTURES);
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (WolfIdleParticle particle : queuedRenders) {
            particle.renderQueued(tessellator);
        }
        tessellator.func_78381_a();
        queuedRenders.clear();
    }

    public void renderQueued(Tessellator tessellator) {
        float numFrames = 2.0f;
        float width = 16.0f;
        float minU = width * (float)this.field_94054_b / (numFrames * width);
        float maxU = minU + width / (numFrames * width);
        float minV = 0.0f;
        float maxV = 1.0f;
        float scale = 0.1f * this.field_70544_f;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-this.rotationX * scale - this.rotationXY * scale), (double)(-this.rotationZ * scale), (double)(-this.rotationYZ * scale - this.rotationXZ * scale)), new Vec3d((double)(-this.rotationX * scale + this.rotationXY * scale), (double)(this.rotationZ * scale), (double)(-this.rotationYZ * scale + this.rotationXZ * scale)), new Vec3d((double)(this.rotationX * scale + this.rotationXY * scale), (double)(this.rotationZ * scale), (double)(this.rotationYZ * scale + this.rotationXZ * scale)), new Vec3d((double)(this.rotationX * scale - this.rotationXY * scale), (double)(-this.rotationZ * scale), (double)(this.rotationYZ * scale - this.rotationXZ * scale))};
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)this.partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)this.partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)this.partialTicks - field_70555_ap);
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
    }
}

