/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems.items.baubles;

import baubles.api.BaubleType;
import com.corwinjv.mobtotems.entities.EntitySpiritWolf;
import com.corwinjv.mobtotems.items.baubles.BaubleItem;
import com.corwinjv.mobtotems.utils.BlockUtils;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class WolfTotemBauble
extends BaubleItem {
    private static final String WOLF_ID = "WOLF_ID";
    private static final String WOLF_TOTEM_COMPOUND = "WOLF_TOTEM_COMPOUND";
    private static final int SPAWN_DISTANCE = 3;
    private static final long UPDATE_TICKS = 20L;
    private static final int CHARGE_COST_PER_TICK = 1;

    @Override
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.AMULET;
    }

    @Override
    public int getMaxChargeLevel() {
        return 32;
    }

    @Override
    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
    }

    @Override
    protected NBTTagCompound initNbtData(ItemStack stack) {
        super.initNbtData(stack);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        NBTTagCompound wolfTotemCompound = tagCompound.func_74775_l(WOLF_TOTEM_COMPOUND);
        wolfTotemCompound.func_74778_a(WOLF_ID, "");
        tagCompound.func_74782_a(WOLF_TOTEM_COMPOUND, (NBTBase)wolfTotemCompound);
        stack.func_77982_d(tagCompound);
        return tagCompound;
    }

    private boolean hasValidNbt(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            FMLLog.log((Level)Level.WARN, (String)"WolfTotemBauble onBaubleActivated() no tagCompound", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private void setWolfId(@Nonnull ItemStack stack, @Nonnull String wolfId) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        NBTTagCompound wolfTotemCompound = tagCompound.func_74775_l(WOLF_TOTEM_COMPOUND);
        wolfTotemCompound.func_74778_a(WOLF_ID, wolfId);
    }

    @Nullable
    private EntitySpiritWolf getWolf(@Nonnull ItemStack stack, @Nonnull World world) {
        NBTTagCompound wolfTotemCompound;
        String wolfId;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && !StringUtils.func_151246_b((String)(wolfId = (wolfTotemCompound = tagCompound.func_74775_l(WOLF_TOTEM_COMPOUND)).func_74779_i(WOLF_ID)))) {
            UUID wolfUUID = UUID.fromString(wolfId);
            Predicate<EntitySpiritWolf> spiritWolfForUUID = input -> input != null && input.func_110124_au().equals(wolfUUID);
            ArrayList entities = new ArrayList(world.func_175644_a(EntitySpiritWolf.class, spiritWolfForUUID::test));
            if (entities.size() > 0) {
                return (EntitySpiritWolf)((Object)entities.get(0));
            }
        }
        return null;
    }

    @Override
    public void onBaubleActivated(ItemStack stack, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            if (!this.hasValidNbt(stack)) {
                return;
            }
            NBTTagCompound tagCompound = stack.func_77978_p();
            NBTTagCompound wolfTotemCompound = tagCompound.func_74775_l(WOLF_TOTEM_COMPOUND);
            EntitySpiritWolf spiritWolf = this.getWolf(stack, player.field_70170_p);
            if (spiritWolf == null && tagCompound.func_74762_e("CHARGE_LEVEL") > 0) {
                double posZ;
                double posY;
                Vec3i facingVec = player.func_174811_aO().func_176730_m();
                double posX = player.field_70165_t + (double)(facingVec.func_177958_n() * 3);
                BlockPos blockPos = new BlockPos((int)posX, (int)(posY = player.field_70163_u), (int)(posZ = player.field_70161_v + (double)(facingVec.func_177952_p() * 3)));
                if (!BlockUtils.isAreaSolid(player, blockPos)) {
                    spiritWolf = this.spawnSpiritWolf(player.field_70170_p, posX, posY, posZ);
                    spiritWolf.tame(player);
                    wolfTotemCompound.func_74778_a(WOLF_ID, spiritWolf.getPersistentID().toString());
                }
            } else if (spiritWolf != null) {
                spiritWolf.func_70106_y();
                wolfTotemCompound.func_74778_a(WOLF_ID, "");
            }
            tagCompound.func_74782_a(WOLF_TOTEM_COMPOUND, (NBTBase)wolfTotemCompound);
        }
    }

    private EntitySpiritWolf spawnSpiritWolf(World worldIn, double x, double y, double z) {
        EntitySpiritWolf entityliving = new EntitySpiritWolf(worldIn);
        entityliving.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        ((EntityLiving)entityliving).field_70759_as = ((EntityLiving)entityliving).field_70177_z;
        ((EntityLiving)entityliving).field_70761_aq = ((EntityLiving)entityliving).field_70177_z;
        entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), null);
        worldIn.func_72838_d((Entity)entityliving);
        entityliving.func_70642_aH();
        return entityliving;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        World world = player.func_130014_f_();
        if (!world.field_72995_K) {
            long worldTime = world.func_72912_H().func_76073_f();
            EntitySpiritWolf spiritWolf = this.getWolf(stack, world);
            if (worldTime % 20L == 0L && spiritWolf != null) {
                this.decrementChargeLevel(stack, 1);
            }
            if (spiritWolf != null && this.getChargeLevel(stack) == 0) {
                spiritWolf.func_70106_y();
                this.setWolfId(stack, "");
            }
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (!player.func_130014_f_().field_72995_K) {
            EntitySpiritWolf spiritWolf = this.getWolf(stack, player.func_130014_f_());
            if (spiritWolf != null) {
                spiritWolf.func_70106_y();
            }
            this.setWolfId(stack, "");
        }
    }
}

