/*
 * Decompiled with CFR 0.152.
 */
package com.corwinjv.mobtotems;

import com.corwinjv.mobtotems.blocks.TotemType;
import com.corwinjv.mobtotems.blocks.tiles.OfferingBoxTileEntity;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.BlazeLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.CowLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.CreeperLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.EnderLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.LlamaLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.Modifiers;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.OcelotLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.RabbitLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.SpiderLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.TotemLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.WitherLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemLogic.WolfLogic;
import com.corwinjv.mobtotems.blocks.tiles.TotemTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TotemHelper {
    public static final int DEFAULT_RADIUS = 32;
    public static final int RANGE_BOOST = 16;
    public static final int MAX_TOTEM_HEIGHT = 3;
    private static Map<TotemType, Class<? extends TotemLogic>> totemMap = new HashMap<TotemType, Class<? extends TotemLogic>>();

    public static void init() {
        totemMap.put(TotemType.NONE, null);
        totemMap.put(TotemType.CREEPER, CreeperLogic.class);
        totemMap.put(TotemType.ENDER, EnderLogic.class);
        totemMap.put(TotemType.BLAZE, BlazeLogic.class);
        totemMap.put(TotemType.SPIDER, SpiderLogic.class);
        totemMap.put(TotemType.COW, CowLogic.class);
        totemMap.put(TotemType.WOLF, WolfLogic.class);
        totemMap.put(TotemType.OCELOT, OcelotLogic.class);
        totemMap.put(TotemType.WITHER, WitherLogic.class);
        totemMap.put(TotemType.LLAMA, LlamaLogic.class);
        totemMap.put(TotemType.RABBIT, RabbitLogic.class);
    }

    @Nullable
    public static TotemLogic getTotemLogic(TotemType totemType) {
        TotemLogic ret = null;
        if (totemMap.containsKey((Object)totemType)) {
            try {
                if (totemMap.get((Object)totemType) != null) {
                    ret = totemMap.get((Object)totemType).newInstance();
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Nonnull
    public static List<ItemStack> getCostForTotemType(TotemType totemType) {
        List<ItemStack> cost = new ArrayList<ItemStack>();
        TotemLogic logic = TotemHelper.getTotemLogic(totemType);
        if (logic != null) {
            cost = logic.getCost();
        }
        return cost;
    }

    public static void sortEffectsAndModifiers(List<TotemType> list, List<TotemType> effectsList, List<TotemType> modifiersList) {
        for (TotemType type : list) {
            TotemLogic logic = TotemHelper.getTotemLogic(type);
            if (logic == null) continue;
            switch (logic.getEffectType()) {
                case EFFECT: {
                    effectsList.add(type);
                    break;
                }
                case MODIFIER: {
                    modifiersList.add(type);
                }
            }
        }
    }

    public static boolean hasTotemType(OfferingBoxTileEntity tileEntity, TotemType totemType) {
        for (TotemType type : tileEntity.getSlaveTypes()) {
            if (type != totemType) continue;
            return true;
        }
        return false;
    }

    public static Modifiers getModifiers(World world, OfferingBoxTileEntity tileEntity) {
        Modifiers mods = new Modifiers();
        for (TotemType type : tileEntity.getSlaveTypes()) {
            TotemLogic logic = TotemHelper.getTotemLogic(type);
            if (logic == null) continue;
            mods = logic.adjustModifiers(mods);
        }
        return mods;
    }

    public static List<BlockPos> checkForSlaveAboveRecursively(World world, BlockPos startPos, int height) {
        TileEntity totemTileEntity;
        ArrayList<BlockPos> totemTileList = new ArrayList<BlockPos>();
        if (height > 0 && (totemTileEntity = world.func_175625_s(startPos)) instanceof TotemTileEntity) {
            totemTileList.add(startPos);
            List<BlockPos> tmpList = TotemHelper.checkForSlaveAboveRecursively(world, startPos.func_177982_a(0, 1, 0), height - 1);
            for (BlockPos te : tmpList) {
                totemTileList.add(te);
            }
        }
        return totemTileList;
    }
}

