/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.soundmuffler.network.messages;

import edgarallen.soundmuffler.SuperSoundMuffler;
import edgarallen.soundmuffler.block.TileEntitySoundMuffler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageToggleWhiteList
implements IMessage {
    BlockPos pos;
    Type type;

    public MessageToggleWhiteList() {
    }

    public MessageToggleWhiteList(BlockPos pos, Type type) {
        this.pos = pos;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.type = buf.readBoolean() ? Type.Bauble : Type.TileEntity;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeBoolean(this.type == Type.Bauble);
    }

    public static enum Type {
        Bauble,
        TileEntity;

    }

    public static class Handler
    implements IMessageHandler<MessageToggleWhiteList, IMessage> {
        public IMessage onMessage(MessageToggleWhiteList message, MessageContext ctx) {
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
            if (thread.func_152345_ab()) {
                this.handle(message, ctx);
            } else {
                thread.func_152344_a(() -> this.handle(message, ctx));
            }
            return null;
        }

        private void handle(MessageToggleWhiteList message, MessageContext ctx) {
            switch (message.type) {
                case Bauble: {
                    this.handleBauble(message, ctx);
                    break;
                }
                case TileEntity: {
                    this.handleTileEntity(message, ctx);
                }
            }
        }

        private void handleBauble(MessageToggleWhiteList message, MessageContext ctx) {
            ItemStack stack;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player != null && !(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b() == SuperSoundMuffler.itemSoundMufflerBauble) {
                SuperSoundMuffler.itemSoundMufflerBauble.toggleWhiteList(stack);
            }
        }

        private void handleTileEntity(MessageToggleWhiteList message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_175625_s(message.pos);
            if (te != null && te instanceof TileEntitySoundMuffler) {
                TileEntitySoundMuffler tileEntity = (TileEntitySoundMuffler)te;
                tileEntity.toggleWhiteListMode();
            }
        }
    }
}

