/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.item.IResetUseOnDamage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWarpStone
extends Item
implements IResetUseOnDamage {
    public static final String name = "warp_stone";
    public static final ResourceLocation registryName = new ResourceLocation("waystones", "warp_stone");
    public static long lastTimerUpdate;

    public ItemWarpStone() {
        this.setRegistryName(name);
        this.func_77655_b(registryName.toString());
        this.func_77637_a(Waystones.creativeTab);
        this.func_77625_d(1);
        this.func_77656_e(100);
    }

    public int func_77626_a(ItemStack itemStack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        if (Waystones.proxy.isVivecraftInstalled()) {
            return EnumAction.NONE;
        }
        return EnumAction.BOW;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, EntityLivingBase entityLiving) {
        if (world.field_72995_K) {
            Waystones.proxy.openWaystoneSelection(WarpMode.WARP_STONE, entityLiving.func_184600_cs(), null);
        }
        return itemStack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.field_71075_bZ.field_75098_d) {
            PlayerWaystoneHelper.setLastWarpStoneUse(player, 0L);
        }
        if (PlayerWaystoneHelper.canUseWarpStone(player)) {
            if (!player.func_184587_cr() && world.field_72995_K) {
                Waystones.proxy.playSound(SoundEvents.field_187814_ei, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), 2.0f);
            }
            if (Waystones.proxy.isVivecraftInstalled()) {
                this.func_77654_b(itemStack, world, (EntityLivingBase)player);
            } else {
                player.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation("waystones:stoneNotCharged", new Object[0]), true);
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack itemStack) {
        return this.getDurabilityForDisplay(itemStack) > 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        long timeSince = System.currentTimeMillis() - PlayerWaystoneHelper.getLastWarpStoneUse((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        float percentage = (float)timeSince / (float)(WaystoneConfig.general.warpStoneCooldown * 1000);
        return 1.0 - (double)Math.max(0.0f, Math.min(1.0f, percentage));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        return PlayerWaystoneHelper.canUseWarpStone((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        long timeSince;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        long timeLeft = PlayerWaystoneHelper.getLastWarpStoneUse((EntityPlayer)player);
        int secondsLeft = (int)((timeLeft - (timeSince = System.currentTimeMillis() - lastTimerUpdate)) / 1000L);
        if (secondsLeft > 0) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:cooldownLeft", (Object[])new Object[]{secondsLeft}));
        }
    }
}

