/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui;

import javax.annotation.Nullable;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.client.gui.GuiButtonRemoveWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonSortWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonWaystoneEntry;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageRemoveWaystone;
import net.blay09.mods.waystones.network.message.MessageSortWaystone;
import net.blay09.mods.waystones.network.message.MessageTeleportToWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

public class GuiWaystoneList
extends GuiScreen {
    private final WarpMode warpMode;
    private final EnumHand hand;
    private final WaystoneEntry fromWaystone;
    private WaystoneEntry[] entries;
    private GuiButton btnPrevPage;
    private GuiButton btnNextPage;
    private int pageOffset;
    private int headerY;

    public GuiWaystoneList(WaystoneEntry[] entries, WarpMode warpMode, EnumHand hand, @Nullable WaystoneEntry fromWaystone) {
        this.entries = entries;
        this.warpMode = warpMode;
        this.hand = hand;
        this.fromWaystone = fromWaystone;
    }

    public void func_73866_w_() {
        this.btnPrevPage = new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones:warpStone.previousPage", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnPrevPage);
        this.btnNextPage = new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones:warpStone.nextPage", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnNextPage);
        this.updateList();
    }

    public void updateList() {
        int maxContentHeight = (int)((float)this.field_146295_m * 0.8f);
        int headerHeight = 40;
        int footerHeight = 25;
        int entryHeight = 25;
        int maxButtonsPerPage = (maxContentHeight - 40 - 25) / 25;
        int buttonsPerPage = Math.max(4, Math.min(maxButtonsPerPage, this.entries.length));
        int contentHeight = 40 + buttonsPerPage * 25 + 25;
        this.headerY = this.field_146295_m / 2 - contentHeight / 2;
        this.btnPrevPage.field_146124_l = this.pageOffset > 0;
        this.btnNextPage.field_146124_l = this.pageOffset < (this.entries.length - 1) / buttonsPerPage;
        this.field_146292_n.removeIf(button -> button instanceof GuiButtonWaystoneEntry || button instanceof GuiButtonSortWaystone || button instanceof GuiButtonRemoveWaystone);
        int id = 2;
        int y = 40;
        for (int i = 0; i < buttonsPerPage; ++i) {
            int entryIndex = this.pageOffset * buttonsPerPage + i;
            if (entryIndex < 0 || entryIndex >= this.entries.length) continue;
            GuiButtonWaystoneEntry btnWaystone = new GuiButtonWaystoneEntry(id, this.field_146294_l / 2 - 100, this.headerY + y, this.entries[entryIndex], this.warpMode);
            if (this.entries[entryIndex].equals(this.fromWaystone)) {
                btnWaystone.field_146124_l = false;
            }
            this.field_146292_n.add(btnWaystone);
            GuiButtonSortWaystone sortUp = new GuiButtonSortWaystone(++id, this.field_146294_l / 2 + 108, this.headerY + y + 2, btnWaystone, -1);
            if (entryIndex == 0) {
                sortUp.field_146125_m = false;
            }
            this.field_146292_n.add(sortUp);
            GuiButtonSortWaystone sortDown = new GuiButtonSortWaystone(++id, this.field_146294_l / 2 + 108, this.headerY + y + 11, btnWaystone, 1);
            if (entryIndex == this.entries.length - 1) {
                sortDown.field_146125_m = false;
            }
            this.field_146292_n.add(sortDown);
            GuiButtonRemoveWaystone remove = new GuiButtonRemoveWaystone(++id, this.field_146294_l / 2 + 122, this.headerY + y + 4, btnWaystone);
            this.field_146292_n.add(remove);
            ++id;
            y += 22;
        }
        this.btnPrevPage.field_146129_i = this.headerY + 40 + buttonsPerPage * 22 + (this.entries.length > 0 ? 10 : 0);
        this.btnNextPage.field_146129_i = this.headerY + 40 + buttonsPerPage * 22 + (this.entries.length > 0 ? 10 : 0);
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.btnNextPage) {
            ++this.pageOffset;
            this.updateList();
        } else if (button == this.btnPrevPage) {
            --this.pageOffset;
            this.updateList();
        } else if (button instanceof GuiButtonWaystoneEntry) {
            NetworkHandler.channel.sendToServer((IMessage)new MessageTeleportToWaystone(((GuiButtonWaystoneEntry)button).getWaystone(), this.warpMode, this.hand, this.fromWaystone));
            this.field_146297_k.func_147108_a(null);
        } else if (button instanceof GuiButtonSortWaystone) {
            WaystoneEntry waystoneEntry = ((GuiButtonSortWaystone)button).getWaystone();
            int index = ArrayUtils.indexOf((Object[])this.entries, (Object)waystoneEntry);
            int sortDir = ((GuiButtonSortWaystone)button).getSortDir();
            int otherIndex = index + sortDir;
            if (index == -1 || otherIndex < 0 || otherIndex >= this.entries.length) {
                return;
            }
            WaystoneEntry swap = this.entries[index];
            this.entries[index] = this.entries[otherIndex];
            this.entries[otherIndex] = swap;
            NetworkHandler.channel.sendToServer((IMessage)new MessageSortWaystone(index, otherIndex));
            this.updateList();
        } else if (button instanceof GuiButtonRemoveWaystone) {
            WaystoneEntry waystoneEntry = ((GuiButtonRemoveWaystone)button).getWaystone();
            int index = ArrayUtils.indexOf((Object[])this.entries, (Object)waystoneEntry);
            this.entries = (WaystoneEntry[])ArrayUtils.remove((Object[])this.entries, (int)index);
            NetworkHandler.channel.sendToServer((IMessage)new MessageRemoveWaystone(index));
            this.updateList();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146270_b(0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.waystones:warpStone.selectDestination", (Object[])new Object[0]), this.field_146294_l / 2, this.headerY + (this.fromWaystone != null ? 20 : 0), 0xFFFFFF);
        if (this.fromWaystone != null) {
            this.func_73732_a(this.field_146289_q, TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.waystones:current_location", (Object[])new Object[0]) + TextFormatting.WHITE + " " + this.fromWaystone.getName(), this.field_146294_l / 2, this.headerY, 0xFFFFFF);
        }
        if (this.entries.length == 0) {
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + I18n.func_135052_a((String)"waystones:scrollNotBound", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
        }
    }
}

