/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.render;

import com.google.gson.JsonObject;
import gnu.trove.map.TObjectByteMap;
import gnu.trove.map.custom_hash.TObjectByteCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextCTM;
import team.chisel.ctm.client.texture.render.AbstractTexture;
import team.chisel.ctm.client.texture.type.TextureTypeCTM;
import team.chisel.ctm.client.util.BlockstatePredicateParser;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.ParseUtils;
import team.chisel.ctm.client.util.Quad;

@ParametersAreNonnullByDefault
public class TextureCTM<T extends TextureTypeCTM>
extends AbstractTexture<T> {
    private static final BlockstatePredicateParser predicateParser = new BlockstatePredicateParser();
    private final Optional<Boolean> connectInside;
    private final boolean ignoreStates;
    @Nullable
    private final BiPredicate<EnumFacing, IBlockState> connectionChecks;
    private final Map<CacheKey, TObjectByteMap<IBlockState>> connectionCache = new HashMap<CacheKey, TObjectByteMap<IBlockState>>();

    public TextureCTM(T type, TextureInfo info) {
        super(type, info);
        this.connectInside = info.getInfo().flatMap(obj -> ParseUtils.getBoolean(obj, "connect_inside"));
        this.ignoreStates = info.getInfo().map(obj -> JsonUtils.func_151209_a((JsonObject)obj, (String)"ignore_states", (boolean)false)).orElse(false);
        this.connectionChecks = info.getInfo().map(obj -> predicateParser.parse(obj.get("connect_to"))).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectTo(CTMLogic ctm, IBlockState from, IBlockState to, EnumFacing dir) {
        Map<CacheKey, TObjectByteMap<IBlockState>> map = this.connectionCache;
        synchronized (map) {
            TObjectByteMap sidecache = this.connectionCache.computeIfAbsent(new CacheKey(from, dir), k -> new TObjectByteCustomHashMap((HashingStrategy)new IdentityHashingStrategy(), 10, 0.5f, -1));
            byte cached = sidecache.get((Object)to);
            if (cached == -1) {
                cached = (byte)((this.connectionChecks == null ? CTMLogic.StateComparisonCallback.DEFAULT.connects(ctm, from, to, dir) : this.connectionChecks.test(dir, to)) ? 1 : 0);
                sidecache.put((Object)to, cached);
            }
            return cached == 1;
        }
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad bq, ITextureContext context, int quadGoal) {
        Quad quad = this.makeQuad(bq, context);
        if (context == null) {
            return Collections.singletonList(quad.transformUVs(this.sprites[0]).rebake());
        }
        Quad[] quads = quad.subdivide(4);
        int[] ctm = ((TextureContextCTM)context).getCTM(bq.func_178210_d()).getSubmapIndices();
        for (int i = 0; i < quads.length; ++i) {
            Quad q2 = quads[i];
            if (q2 == null) continue;
            int ctmid = q2.getUvs().normalize().getQuadrant();
            quads[i] = q2.grow().transformUVs(this.sprites[ctm[ctmid] > 15 ? 0 : 1], CTMLogic.uvs[ctm[ctmid]].normalize());
        }
        return Arrays.stream(quads).filter(Objects::nonNull).map(q -> q.rebake()).collect(Collectors.toList());
    }

    @Override
    protected Quad makeQuad(BakedQuad bq, ITextureContext context) {
        return super.makeQuad(bq, context).derotate();
    }

    public Optional<Boolean> connectInside() {
        return this.connectInside;
    }

    public boolean ignoreStates() {
        return this.ignoreStates;
    }

    private static final class CacheKey {
        private final IBlockState from;
        private final EnumFacing dir;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dir.hashCode();
            result = 31 * result + System.identityHashCode(this.from);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.dir != other.dir) {
                return false;
            }
            return this.from == other.from;
        }

        @ConstructorProperties(value={"from", "dir"})
        public CacheKey(IBlockState from, EnumFacing dir) {
            this.from = from;
            this.dir = dir;
        }
    }
}

