/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.util.json;

import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Recipe;
import chbachman.armour.ModularArmour;
import chbachman.armour.util.json.CustomIUpgradeJson;
import chbachman.armour.util.json.CustomItemStackJson;
import chbachman.armour.util.json.CustomRecipeJson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class JsonRegister {
    public static void registerCustomSerializers(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter(ItemStack.class, (Object)new CustomItemStackJson());
        gsonBuilder.registerTypeAdapter(IUpgrade.class, (Object)new CustomIUpgradeJson());
        gsonBuilder.registerTypeAdapter(Recipe.class, (Object)new CustomRecipeJson());
    }

    public static void createJsonRecipes(GsonBuilder gsonBuilder) {
        File folder = new File(ModularArmour.getConfigDirectory(), "recipes");
        folder.mkdir();
        if (folder.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json")).length == 0) {
            for (Recipe recipe : UpgradeRegistry.getRecipeList()) {
                JsonRegister.writeRecipeToFile(gsonBuilder, recipe, folder);
            }
        }
    }

    public static void registerJsonRecipes(GsonBuilder gsonBuilder) {
        File folder = new File(ModularArmour.getConfigDirectory(), "recipes");
        folder.mkdir();
        File[] files = folder.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        UpgradeRegistry.INSTANCE.recipeList.clear();
        for (File file : files) {
            UpgradeRegistry.registerRecipe(JsonRegister.createRecipeFromJson(gsonBuilder, file));
        }
    }

    public static void writeRecipeToFile(GsonBuilder gsonBuilder, Recipe recipe, File directory) {
        String baseName = recipe.getRecipeOutput().getBaseName();
        File destination = new File(directory, baseName + ".json");
        int counter = 0;
        while (destination.exists()) {
            destination = new File(directory, baseName + counter + ".json");
            ++counter;
        }
        try {
            FileWriter writer = new FileWriter(destination);
            writer.write(JsonRegister.createJsonFromRecipe(gsonBuilder, recipe));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String createJsonFromRecipe(GsonBuilder gsonBuilder, Recipe recipe) {
        return gsonBuilder.setPrettyPrinting().create().toJson((Object)recipe, Recipe.class);
    }

    public static Recipe createRecipeFromJson(GsonBuilder gsonBuilder, File file) {
        try {
            return (Recipe)gsonBuilder.setPrettyPrinting().create().fromJson((Reader)new FileReader(file), Recipe.class);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

