/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.util.json;

import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Recipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class CustomRecipeJson
implements JsonDeserializer<Recipe>,
JsonSerializer<Recipe> {
    public JsonElement serialize(Recipe src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.add("output", context.serialize((Object)src.getRecipeOutput(), IUpgrade.class));
        json.addProperty("width", (Number)src.width);
        json.addProperty("height", (Number)src.height);
        for (int i = 0; i < 3; ++i) {
            JsonArray array = new JsonArray();
            for (int x = 0; x < 3; ++x) {
                Object toSerialize = src.getInput()[i * 3 + x];
                if (toSerialize instanceof String) {
                    array.add((JsonElement)new JsonPrimitive((String)toSerialize));
                } else if (toSerialize instanceof ItemStack) {
                    array.add(context.serialize((Object)((ItemStack)toSerialize), ItemStack.class));
                }
                if (toSerialize != null) continue;
                array.add((JsonElement)JsonNull.INSTANCE);
            }
            json.add("row" + (i + 1), (JsonElement)array);
        }
        return json;
    }

    public Recipe deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject json = element.getAsJsonObject();
        IUpgrade output = (IUpgrade)context.deserialize(json.get("output"), IUpgrade.class);
        ArrayList<String> list = new ArrayList<String>();
        JsonArray array = new JsonArray();
        array.addAll(json.get("row1").getAsJsonArray());
        array.addAll(json.get("row2").getAsJsonArray());
        array.addAll(json.get("row3").getAsJsonArray());
        for (JsonElement e : array) {
            if (e.isJsonNull()) {
                list.add(null);
                continue;
            }
            if (!e.isJsonObject()) {
                list.add(e.getAsString());
                continue;
            }
            list.add((String)((ItemStack)context.deserialize(e, ItemStack.class)));
        }
        Recipe recipe = new Recipe(output, list.toArray(), json.get("width").getAsInt(), json.get("height").getAsInt());
        recipe.width = json.get("width").getAsInt();
        recipe.height = json.get("height").getAsInt();
        return recipe;
    }
}

