/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Type;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CustomItemStackJson
implements JsonDeserializer<ItemStack>,
JsonSerializer<ItemStack> {
    public ItemStack deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject json = element.getAsJsonObject();
        boolean isBlock = json.get("isBlock").getAsBoolean();
        String name = json.get("name").getAsString();
        int meta = json.get("metadata").getAsInt();
        ItemStack stack = isBlock ? new ItemStack((Block)GameData.getBlockRegistry().func_82594_a(name), 1, meta) : new ItemStack((Item)GameData.getItemRegistry().func_82594_a(name), 1, meta);
        stack.field_77990_d = (NBTTagCompound)context.deserialize(json.get("nbt"), NBTTagCompound.class);
        return stack;
    }

    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("isBlock", Boolean.valueOf(src.func_77973_b() instanceof ItemBlock));
        if (src.func_77973_b() instanceof ItemBlock) {
            jsonObject.addProperty("name", GameData.getBlockRegistry().func_148750_c((Object)Block.func_149634_a((Item)src.func_77973_b())));
        } else {
            jsonObject.addProperty("name", GameData.getItemRegistry().func_148750_c((Object)src.func_77973_b()));
        }
        jsonObject.addProperty("metadata", (Number)src.func_77960_j());
        jsonObject.add("nbt", context.serialize((Object)src.field_77990_d, NBTTagCompound.class));
        return jsonObject;
    }
}

