/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.register;

import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Recipe;
import chbachman.armour.register.Module;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.modularArmour")
public class MineTweaker
implements Module {
    @ZenMethod
    public static void addRecipe(String output, IIngredient[][] params) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, params));
    }

    @ZenMethod
    public static void remove(String output) {
        MineTweaker.removeRecipe(output, null);
    }

    @ZenMethod
    public static void removeRecipe(String output, @Optional IIngredient[][] ingredients) {
        IUpgrade upgrade = UpgradeRegistry.getUpgrade(output);
        if (upgrade == null) {
            MineTweakerAPI.logError((String)("Not an valid upgrade: " + output));
        }
        MineTweakerAPI.logInfo((String)("Removing Recipe for: " + upgrade.getName()));
        ArrayList<Recipe> toRemove = new ArrayList<Recipe>();
        for (Recipe recipe : UpgradeRegistry.getRecipeList()) {
            if (!recipe.getRecipeOutput().equals(upgrade)) continue;
            if (ingredients == null) {
                toRemove.add(recipe);
                continue;
            }
            for (int i = 0; i < ingredients.length; ++i) {
                for (int g = 0; g < ingredients[i].length; ++g) {
                    if (!ingredients[i][g].matches((IItemStack)new MCItemStack(MineTweaker.getStackInSlot(recipe, i * 3 + g)))) continue;
                    toRemove.add(recipe);
                }
            }
        }
        for (Recipe recipe : toRemove) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(recipe));
        }
    }

    private static ItemStack getStackInSlot(Recipe recipe, int slot) {
        ItemStack[] list = recipe.getItemStackInput()[slot];
        if (list.length == 0) {
            return null;
        }
        return list[0];
    }

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        MineTweakerAPI.registerClass(MineTweaker.class);
    }

    @Override
    public void postInit() {
    }

    @Override
    public void registerUpgrades() {
    }

    @Override
    public void registerUpgradeRecipes() {
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final Recipe recipe;

        public RemoveRecipeAction(Recipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            UpgradeRegistry.removeRecipe(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            UpgradeRegistry.registerRecipe(this.recipe);
        }

        public String describe() {
            return "Removing Modular Armour recipe for " + this.recipe.getRecipeOutput().getName();
        }

        public String describeUndo() {
            return "Restoring Modular Armour recipe for " + this.recipe.getRecipeOutput().getName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final Recipe recipe;

        public AddRecipeAction(String output, IIngredient[][] ingredients) {
            if (ingredients.length != 3 || ingredients[0].length != 3) {
                MineTweakerAPI.logError((String)"Recipe must be a 3x3");
            }
            Object[] mcIngredients = new Object[9];
            for (int i = 0; i < ingredients.length; ++i) {
                for (int g = 0; g < ingredients[i].length; ++g) {
                    List stack = ingredients[i][g].getItems();
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int f = 0; f < stack.size(); ++f) {
                        stacks.add((ItemStack)((IItemStack)stack.get(f)).getInternal());
                    }
                    mcIngredients[i * 3 + g] = stacks.size() == 1 ? stacks.get(0) : stacks;
                }
            }
            IUpgrade upgrade = UpgradeRegistry.getUpgrade(output);
            if (upgrade == null) {
                MineTweakerAPI.logError((String)"Not an valid Upgrade");
            }
            this.recipe = new Recipe(upgrade, mcIngredients, 3, 3);
        }

        public void apply() {
            UpgradeRegistry.registerRecipe(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            UpgradeRegistry.removeRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Modular Armour recipe for " + this.recipe.getRecipeOutput().getName();
        }

        public String describeUndo() {
            return "Removing Modular Armour recipe for " + this.recipe.getRecipeOutput().getName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

