/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.gui.recipe;

import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Recipe;
import chbachman.api.util.ImmutableArray;
import chbachman.armour.gui.GuiHelper;
import chbachman.armour.gui.element.TabCompatible;
import chbachman.armour.gui.element.TabRecipeList;
import chbachman.armour.gui.recipe.RecipeContainer;
import chbachman.armour.network.ArmourPacket;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementTextField;
import cofh.lib.util.helpers.StringHelper;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntArray;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class RecipeGui
extends GuiBaseAdv {
    private static final ResourceLocation TEXTURE = new ResourceLocation("modulararmour:textures/gui/recipeGui.png");
    public RecipeContainer container;
    public ElementButton rightArrow;
    public ElementButton leftArrow;
    public ElementButton upgrade;
    public ElementTextField field;
    public TabCompatible compatible;
    public TabRecipeList list;
    public int index = 0;
    public static final ImmutableArray<Recipe> recipes = UpgradeRegistry.getRecipeList();
    public IntArray indicies = new IntArray();

    public RecipeGui(RecipeContainer container, InventoryPlayer inventory) {
        super((Container)container, TEXTURE);
        this.container = container;
        this.texture = TEXTURE;
        this.drawTitle = false;
        this.drawInventory = false;
        this.field_146999_f = 176;
        this.field_147000_g = 172;
        this.leftArrow = new ElementButton((GuiBase)this, 5, 25, "Go Back", 227, 12, 227, 12, 227, 12, 7, 7, TEXTURE.toString());
        this.rightArrow = new ElementButton((GuiBase)this, 164, 25, "Next", 235, 12, 235, 12, 235, 12, 7, 7, TEXTURE.toString());
        this.upgrade = new ElementButton((GuiBase)this, 71, 38, "Upgrade", 71, 38, 71, 38, 16, 16, TEXTURE.toString());
        this.upgrade.setToolTip("Add Upgrade?");
        this.field = new ElementTextField((GuiBase)this, 7, 6, 162, 11){

            protected void onCharacterEntered(boolean success) {
                if (success) {
                    RecipeGui.this.handleTyping(this.getText());
                }
            }
        };
        this.field.setBackgroundColor((Number)-16777216, (Number)-16777216, (Number)-16777216);
        this.list = new TabRecipeList((GuiBase)this, this.indicies){

            @Override
            public void onUpgradeSelected(IUpgrade upgrade, int index) {
                RecipeGui.this.index = index;
                RecipeGui.this.syncAndWrapIndex();
            }
        };
        this.compatible = new TabCompatible((GuiBase)this, this.container);
        this.rightArrow.setToolTip("Next");
        this.leftArrow.setToolTip("Back");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab(this.compatible);
        this.addTab(this.list);
        this.addElement((ElementBase)this.leftArrow);
        this.addElement((ElementBase)this.rightArrow);
        this.addElement((ElementBase)this.upgrade);
        this.addElement((ElementBase)this.field);
        this.handleTyping("");
    }

    protected void func_146976_a(float partialTick, int x, int y) {
        super.func_146976_a(partialTick, x, y);
        if (this.container.recipe != null) {
            IUpgrade upgrade = this.container.recipe.getRecipeOutput();
            GuiHelper.drawStringBounded((GuiBase)this, StringHelper.localize((String)upgrade.getName()), 70, this.field_147003_i + 100, this.field_147009_r + 38, 0xFFFFFF);
            GuiHelper.drawStringBounded((GuiBase)this, StringHelper.localize((String)upgrade.getInformation()), 159, this.field_147003_i + 11, this.field_147009_r + 100, 0xFFFFFF);
        }
    }

    public void handleTyping(String text) {
        int i;
        this.indicies.clear();
        if (text.isEmpty()) {
            for (i = 0; i < recipes.size(); ++i) {
                this.indicies.add(i);
            }
        }
        text = text.toLowerCase();
        for (i = 0; i < recipes.size(); ++i) {
            String name = StringHelper.localize((String)recipes.get(i).getRecipeOutput().getName()).toLowerCase();
            if (!name.contains(text)) continue;
            this.indicies.add(i);
        }
        this.list.updateList();
        this.syncAndWrapIndex();
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        super.handleElementButtonClick(buttonName, mouseButton);
        if (buttonName.equals("Upgrade")) {
            PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.BUTTON).addString("Upgrade"));
        }
        if (buttonName.equals("Go Back")) {
            --this.index;
        } else if (buttonName.equals("Next")) {
            ++this.index;
        }
        this.syncAndWrapIndex();
    }

    private void syncAndWrapIndex() {
        if (this.indicies.size == 0) {
            this.index = -1;
            this.container.updateIndex(this.index);
            PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.BUTTON).addString(" ").addInt(this.index));
        } else {
            this.index = MathUtils.clamp(this.index, 0, this.indicies.size - 1);
            this.container.updateIndex(this.indicies.get(this.index));
            PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.BUTTON).addString(" ").addInt(this.indicies.get(this.index)));
        }
    }

    public void func_73869_a(char characterTyped, int keyPressed) {
        if (keyPressed == 1) {
            PacketHandler.sendToServer((PacketBase)ArmourPacket.getPacket(ArmourPacket.PacketTypes.KEYTYPED).addShort((short)characterTyped).addInt(keyPressed));
            return;
        }
        super.func_73869_a(characterTyped, keyPressed);
    }
}

