/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.gui.recipe;

import chbachman.api.item.IModularItem;
import chbachman.api.registry.ModularItemRegistry;
import chbachman.api.registry.UpgradeRegistry;
import chbachman.api.upgrade.Recipe;
import chbachman.api.util.ImmutableArray;
import chbachman.armour.ModularArmour;
import chbachman.armour.gui.crafting.ArmourContainer;
import chbachman.armour.network.ArmourPacket;
import chbachman.armour.network.IInputHandler;
import chbachman.armour.util.InventoryUtil;
import cofh.lib.gui.slot.SlotViewOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class RecipeContainer
extends Container
implements IInputHandler {
    public final IModularItem item;
    public final EntityPlayer player;
    public final ItemStack stack;
    public Inventory inventory;
    public Recipe recipe;
    public static final ImmutableArray<Recipe> recipes = UpgradeRegistry.getRecipeList();
    public static final ImmutableArray<IModularItem> modularItems = ModularItemRegistry.getItemList();

    public RecipeContainer(ItemStack stack, InventoryPlayer inventory, World world) {
        this.item = (IModularItem)stack.func_77973_b();
        this.stack = stack;
        this.player = inventory.field_70458_d;
        this.recipe = recipes.get(0);
        this.inventory = new Inventory();
        this.bindSlots();
    }

    protected void bindSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotViewOnly((IInventory)this.inventory, i * 3 + j, 9 + j * 18, 37 + i * 18));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @Override
    public void onButtonClick(ArmourPacket packet, String name) {
        if (name.equals("Upgrade")) {
            if (this.checkInventory()) {
                Container playerContainer;
                ItemStack[] stacks = this.grabInventory();
                if (!this.player.field_70170_p.field_72995_K) {
                    this.player.openGui((Object)ModularArmour.instance, 0, this.player.field_70170_p, 0, 0, 0);
                }
                if ((playerContainer = this.player.field_71070_bA) instanceof ArmourContainer) {
                    ArmourContainer crafting = (ArmourContainer)playerContainer;
                    crafting.func_75131_a(stacks);
                    crafting.onSlotChanged();
                }
            }
        } else {
            int index = packet.getInt();
            this.updateIndex(index);
        }
    }

    public void updateIndex(int index) {
        this.recipe = index == -1 ? null : recipes.get(index);
    }

    private ItemStack[] grabInventory() {
        InventoryPlayer playerInventory = this.player.field_71071_by;
        ItemStack[][] input = this.recipe.getItemStackInput();
        ItemStack[] toReturn = new ItemStack[input.length];
        for (int i = 0; i < input.length; ++i) {
            for (int g = 0; g < input[i].length; ++g) {
                for (int k = 0; k < playerInventory.func_70302_i_(); ++k) {
                    ItemStack playerStack = playerInventory.func_70301_a(k);
                    if (!InventoryUtil.itemMatches(input[i][g], playerStack, false)) continue;
                    toReturn[i] = playerInventory.func_70298_a(k, 1);
                }
            }
        }
        return toReturn;
    }

    private boolean checkInventory() {
        InventoryPlayer playerInventory = this.player.field_71071_by;
        if (this.recipe == null) {
            return false;
        }
        ItemStack[][] input = this.recipe.getItemStackInput();
        for (int i = 0; i < input.length; ++i) {
            for (int g = 0; g < input[i].length; ++g) {
                if (InventoryUtil.doesInventoryContainItemStack((IInventory)playerInventory, input[i][g])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void onKeyTyped(ArmourPacket packet, char key, int keyCode) {
        if (!this.player.field_70170_p.field_72995_K) {
            this.player.openGui((Object)ModularArmour.instance, 0, this.player.field_70170_p, 0, 0, 0);
        }
    }

    private class Inventory
    implements IInventory {
        private int counter = 0;
        private int index = 0;

        private Inventory() {
        }

        public int func_70302_i_() {
            return 9;
        }

        public ItemStack func_70301_a(int slot) {
            if (RecipeContainer.this.recipe == null) {
                return null;
            }
            ItemStack[][] items = RecipeContainer.this.recipe.getItemStackInput();
            ItemStack[] toCheck = items[slot];
            ++this.counter;
            if (this.counter == 500 * items.length) {
                this.counter = 0;
                ++this.index;
            }
            if (toCheck.length == 0) {
                return null;
            }
            ItemStack stack = toCheck[this.index % toCheck.length];
            stack.field_77994_a = 1;
            return stack;
        }

        public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
            return null;
        }

        public ItemStack func_70304_b(int p_70304_1_) {
            return null;
        }

        public void func_70299_a(int slot, ItemStack stack) {
        }

        public String func_145825_b() {
            return "inventory";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer p_70300_1_) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
            return true;
        }
    }
}

