/*
 * Decompiled with CFR 0.152.
 */
package chbachman.armour.gui.element;

import chbachman.armour.gui.crafting.ArmourGui;
import chbachman.armour.gui.element.ElementButtonIcon;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TabCrafting
extends TabBase {
    public static ResourceLocation GRID_TEXTURE = new ResourceLocation("cofh:textures/gui/elements/Slot_Grid_Augment.png");
    ArmourGui armourGui;
    int slotsBorderX1 = 7;
    int slotsBorderY1 = 20;
    ElementButtonIcon accept;
    ElementButtonIcon recipe;
    ElementButtonIcon cancel;

    public TabCrafting(ArmourGui gui) {
        super((GuiBase)gui, 1);
        this.backgroundColor = 13311;
        this.armourGui = gui;
        this.maxHeight = 110;
        this.maxWidth = 93;
        this.moveSlots(this.open);
        this.accept = new ElementButtonIcon(this.gui, gui.getIcon("IconAccept"), 70, 24, 16, 16);
        this.recipe = new ElementButtonIcon(this.gui, gui.getIcon("IconRecipe"), 70, 60, 16, 16);
        this.cancel = new ElementButtonIcon(this.gui, gui.getIcon("IconCancel"), 70, 42, 16, 16);
        this.accept.addTooltip(Collections.singletonList("Add Upgrade"));
        this.recipe.addTooltip(Collections.singletonList("Recipes"));
        this.cancel.addTooltip(Collections.singletonList("Remove Items"));
        this.addElement((ElementBase)this.accept);
        this.addElement((ElementBase)this.cancel);
        this.addElement((ElementBase)this.recipe);
        this.accept.setActionName("UpgradeAddition");
        this.cancel.setActionName("RemoveItems");
        this.recipe.setActionName("Recipe");
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        super.drawBackground(mouseX, mouseY, gameTicks);
        this.drawTabIcon("IconUpgrade");
        if (this.isFullyOpened()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.bindTexture((ResourceLocation)GRID_TEXTURE);
            this.drawSlots(0, 0, 3);
            this.drawSlots(0, 1, 3);
            this.drawSlots(0, 2, 3);
        }
        this.accept.setEnabled(this.armourGui.container.upgrade != null);
    }

    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        if (!this.isFullyOpened()) {
            return;
        }
        if (this.armourGui.container.upgrade != null) {
            List list = this.getFontRenderer().func_78271_c(StringHelper.localize((String)this.armourGui.container.upgrade.getName()), 70);
            for (int i = 0; i < list.size(); ++i) {
                String lineToDraw = this.getFontRenderer().func_78269_a((String)list.get(i), 90);
                this.getFontRenderer().func_78261_a(lineToDraw, this.posX + 3, 87 + 10 * i, -1);
            }
        } else {
            this.getFontRenderer().func_78261_a("No Upgrade", this.posX + 3, 87, -1);
            this.getFontRenderer().func_78261_a("Selected Yet!", this.posX + 3, 97, -1);
        }
        this.getFontRenderer().func_78261_a("Upgrades", this.posXOffset() + 18, this.posY + 8, this.headerColor);
    }

    public void addTooltip(List<String> list) {
        super.addTooltip(list);
        if (!this.isFullyOpened()) {
            list.add("Upgrade");
        }
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        super.onMousePressed(mouseX, mouseY, mouseButton);
        return !this.isCoordsInBorders(mouseX -= this.currentShiftX, mouseY -= this.currentShiftY, 0, 16, 0, 16);
    }

    public boolean isCoordsInBorders(int xCoord, int yCoord, int x, int x2, int y, int y2) {
        return xCoord > x && xCoord < x2 && yCoord > y && yCoord < y2;
    }

    protected void drawBackground() {
        super.drawBackground();
    }

    public void setFullyOpen() {
        super.setFullyOpen();
        this.moveSlots(true);
    }

    public void toggleOpen() {
        if (this.open) {
            this.moveSlots(false);
        }
        super.toggleOpen();
    }

    private void drawButton(String name, int xShift, int yShift, boolean active) {
        if (active) {
            if (this.isCoordsInBorders(this.gui.getMouseX() - this.currentShiftX, this.gui.getMouseY() - this.currentShiftY, xShift, xShift + 16, yShift, yShift + 16)) {
                this.gui.drawButton(name, this.posX + xShift, this.posY + yShift, 1, 1);
            } else {
                this.gui.drawButton(name, this.posX + xShift, this.posY + yShift, 1, 0);
            }
        } else {
            this.gui.drawButton(name, this.posX + xShift, this.posY + yShift, 1, 2);
        }
    }

    private void moveSlots(boolean isOpen) {
        if (!isOpen) {
            for (int i = 0; i < 9; ++i) {
                ((Slot)this.armourGui.container.field_75151_b.get((int)i)).field_75223_e = -this.gui.getGuiLeft() - 16;
                ((Slot)this.armourGui.container.field_75151_b.get((int)i)).field_75221_f = -this.gui.getGuiTop() - 16;
            }
        } else {
            for (int i = 0; i < 9; ++i) {
                ((Slot)this.armourGui.container.field_75151_b.get((int)i)).field_75223_e = this.posXOffset() + this.slotsBorderX1 + 4 + 18 * (i % 3);
                ((Slot)this.armourGui.container.field_75151_b.get((int)i)).field_75221_f = this.posY + this.slotsBorderY1 + 4 + 18 * (i / 3);
            }
        }
    }

    private void drawSlots(int xOffset, int yOffset, int slots) {
        this.gui.drawSizedTexturedModalRect(this.posXOffset() + this.slotsBorderX1 + 3 + 9 * xOffset, this.posY + this.slotsBorderY1 + 3 + 18 * yOffset, 0, 0, 18 * slots, 18, 96.0f, 32.0f);
    }
}

