/*
 * Decompiled with CFR 0.152.
 */
package chbachman.api.upgrade;

import chbachman.api.upgrade.IUpgrade;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class Recipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private IUpgrade output = null;
    private Object[] input = null;
    public int width = 0;
    public int height = 0;
    public boolean mirrored = true;
    private ItemStack[][] itemStackInput;

    public Recipe(IUpgrade result, Object ... recipe) {
        this.output = result;
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, (String)in);
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public Recipe(IUpgrade result, Object[] array, int width, int height) {
        this.input = array;
        this.output = result;
        this.width = width;
        this.height = height;
    }

    public IUpgrade getCraftingResult() {
        return this.output;
    }

    public int getRecipeSize() {
        return this.input.length;
    }

    public IUpgrade getRecipeOutput() {
        return this.output;
    }

    public boolean matches(IInventory inv) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(IInventory inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70301_a(x + y * 3);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof String) {
                    boolean matched = false;
                    Iterator itr = OreDictionary.getOres((String)((String)target)).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(Recipe recipe) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(recipe, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(recipe, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(Recipe inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                Object slot = inv.input[x * 3 + y];
                if (target instanceof ItemStack) {
                    if (!(slot instanceof ItemStack)) {
                        return false;
                    }
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)((ItemStack)slot), (boolean)false)) continue;
                    return false;
                }
                if (target instanceof String) {
                    if (!(slot instanceof String)) {
                        return false;
                    }
                    if (slot.equals(target)) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.input);
        result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)obj;
        if (!this.matches(other)) {
            return false;
        }
        return !(this.output == null ? other.output != null : !this.output.equals(other.output));
    }

    public Object[] getInput() {
        return this.input;
    }

    public ItemStack[][] getItemStackInput() {
        if (this.itemStackInput != null) {
            return this.itemStackInput;
        }
        ItemStack[][] output = new ItemStack[9][];
        Object[] list = this.getInput();
        for (int i = 0; i < list.length; ++i) {
            Object object = list[i];
            if (object == null) {
                output[i] = new ItemStack[0];
            }
            if (object instanceof String) {
                output[i] = OreDictionary.getOres((String)((String)object)).toArray(new ItemStack[0]);
            }
            if (!(object instanceof ItemStack)) continue;
            output[i] = new ItemStack[]{(ItemStack)object};
        }
        this.itemStackInput = output;
        return output;
    }

    public String toString() {
        return "Output: " + this.output.getName() + "Input: " + Arrays.toString(this.input);
    }
}

