/*
 * Decompiled with CFR 0.152.
 */
package chbachman.api.registry;

import chbachman.api.registry.IUpgradeListener;
import chbachman.api.registry.UpgradeList;
import chbachman.api.upgrade.IUpgrade;
import chbachman.api.upgrade.Recipe;
import chbachman.api.util.Array;
import chbachman.api.util.ImmutableArray;
import chbachman.api.util.ObjectMap;

public final class UpgradeRegistry {
    public static UpgradeRegistry INSTANCE = new UpgradeRegistry();
    public UpgradeList upgradeList = new UpgradeList();
    public Array<IUpgradeListener> listenerList = new Array();
    public ObjectMap<IUpgrade, IUpgradeListener[]> listenerMap = new ObjectMap();
    public Array<Recipe> recipeList = new Array();

    public static <T extends IUpgradeListener> T getListenerForUpgrade(IUpgrade upgrade, Class<T> clazz) {
        IUpgradeListener[] list;
        for (IUpgradeListener l : list = UpgradeRegistry.INSTANCE.listenerMap.get(upgrade)) {
            if (l.getClass() != clazz) continue;
            return (T)l;
        }
        return null;
    }

    public static IUpgradeListener registerListener(IUpgradeListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        UpgradeRegistry.INSTANCE.listenerList.add(l);
        return l;
    }

    public static IUpgrade registerUpgrade(IUpgrade upgrade) {
        if (upgrade == null) {
            throw new IllegalArgumentException("Upgrade cannot be null");
        }
        IUpgradeListener[] list = new IUpgradeListener[UpgradeRegistry.INSTANCE.listenerList.size];
        for (int i = 0; i < UpgradeRegistry.INSTANCE.listenerList.size; ++i) {
            list[i] = UpgradeRegistry.INSTANCE.listenerList.get(i).onUpgradeAdded(upgrade);
        }
        UpgradeRegistry.INSTANCE.listenerMap.put(upgrade, list);
        UpgradeRegistry.INSTANCE.upgradeList.put(upgrade);
        return upgrade;
    }

    public static Recipe registerRecipe(Recipe recipe) {
        if (recipe == null) {
            throw new IllegalArgumentException("Recipe cannot be null");
        }
        if (recipe.getRecipeOutput() == null) {
            throw new IllegalArgumentException(String.format("Recipe cannot create a null upgrade. Please fix %s recipe.", recipe.toString()));
        }
        UpgradeRegistry.INSTANCE.recipeList.add(recipe);
        return recipe;
    }

    public static boolean removeRecipe(Recipe recipe) {
        return UpgradeRegistry.INSTANCE.recipeList.removeValue(recipe, false);
    }

    public static boolean removeRecipe(IUpgrade upgrade) {
        boolean found = false;
        for (int i = 0; i < UpgradeRegistry.INSTANCE.recipeList.size; ++i) {
            Recipe recipe = UpgradeRegistry.INSTANCE.recipeList.get(i);
            if (!recipe.getRecipeOutput().equals(upgrade)) continue;
            UpgradeRegistry.INSTANCE.recipeList.removeIndex(i);
            found = true;
        }
        return found;
    }

    public static ImmutableArray<IUpgrade> getUpgradeList() {
        return new ImmutableArray<IUpgrade>(UpgradeRegistry.INSTANCE.upgradeList.values().toArray());
    }

    public static ImmutableArray<Recipe> getRecipeList() {
        return new ImmutableArray<Recipe>(UpgradeRegistry.INSTANCE.recipeList);
    }

    public static IUpgrade getUpgrade(String s) {
        return (IUpgrade)UpgradeRegistry.INSTANCE.upgradeList.get(s);
    }
}

