/*
 * Decompiled with CFR 0.152.
 */
package chbachman.api.registry;

import chbachman.api.item.IModularItem;
import chbachman.api.registry.IItemListener;
import chbachman.api.util.Array;
import chbachman.api.util.ImmutableArray;
import java.util.HashMap;

public final class ModularItemRegistry {
    private static ModularItemRegistry INSTANCE = new ModularItemRegistry();
    private Array<IModularItem> itemList = new Array();
    private Array<IItemListener> listenerList = new Array();
    private HashMap<IModularItem, IItemListener[]> listenerMap = new HashMap();

    private ModularItemRegistry() {
    }

    public static <T extends IItemListener> T getListenerForUpgrade(IModularItem upgrade, Class<T> clazz) {
        IItemListener[] list;
        for (IItemListener l : list = ModularItemRegistry.INSTANCE.listenerMap.get(upgrade)) {
            if (l.getClass() != clazz) continue;
            return (T)l;
        }
        return null;
    }

    public static IItemListener registerListener(IItemListener l) {
        ModularItemRegistry.INSTANCE.listenerList.add(l);
        return l;
    }

    public static IModularItem registerItem(IModularItem upgrade) {
        IItemListener[] list = new IItemListener[ModularItemRegistry.INSTANCE.listenerList.size];
        for (int i = 0; i < ModularItemRegistry.INSTANCE.listenerList.size; ++i) {
            list[i] = ModularItemRegistry.INSTANCE.listenerList.get(i).onItemAdded(upgrade);
        }
        ModularItemRegistry.INSTANCE.listenerMap.put(upgrade, list);
        ModularItemRegistry.INSTANCE.itemList.add(upgrade);
        return upgrade;
    }

    public static ImmutableArray<IModularItem> getItemList() {
        return new ImmutableArray<IModularItem>(ModularItemRegistry.INSTANCE.itemList);
    }

    public static <T extends IModularItem> T getItem(Class<T> s) {
        for (IModularItem item : ModularItemRegistry.INSTANCE.itemList) {
            if (s != item.getClass()) continue;
            return (T)item;
        }
        return null;
    }
}

