/*
 * Decompiled with CFR 0.152.
 */
package chbachman.api.nbt.helper;

import chbachman.api.nbt.NBTSerializer;
import java.util.AbstractList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTList<E>
extends AbstractList<E> {
    public final NBTTagList list;
    public final NBTSerializer<E> type;

    public NBTList(NBTSerializer<E> type) {
        this(new NBTTagList(), type);
    }

    public NBTList(NBTTagList list, NBTSerializer<E> type) {
        this.list = list;
        this.type = type;
    }

    @Override
    public E get(int index) {
        NBTTagCompound nbt = this.list.func_150305_b(index);
        if (nbt == null) {
            return null;
        }
        E data = this.type.loadFromNBT(nbt);
        return data;
    }

    @Override
    public int size() {
        return this.list.func_74745_c();
    }

    @Override
    public void add(int index, E element) {
        if (element == null) {
            return;
        }
        this.list.func_74742_a((NBTBase)new NBTTagCompound());
        for (int i = this.list.func_74745_c() - 2; i >= index; ++i) {
            this.list.func_150304_a(i + 1, (NBTBase)this.list.func_150305_b(i));
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.type.saveToNBT(element, nbt);
        this.list.func_150304_a(index, (NBTBase)nbt);
    }

    @Override
    public E set(int index, E element) {
        E data = this.get(index);
        if (element == null) {
            return data;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.type.saveToNBT(element, nbt);
        this.list.func_150304_a(index, (NBTBase)nbt);
        return data;
    }

    @Override
    public E remove(int index) {
        E data = this.get(index);
        this.list.func_74744_a(index);
        return data;
    }
}

