/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.items;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.EnergyHelper;
import com.gekox.gekosLasers.items.ItemGL;
import com.gekox.gekosLasers.utility.Color;
import com.gekox.gekosLasers.utility.NBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public abstract class ItemLaserThing
extends ItemGL
implements IEnergyContainerItem {
    protected int maxEnergy = 100000;
    public int maxTransfer = 1000;
    public int energyPerUse = 200;
    private int coolDown = 20;
    protected int currentCooldown = 0;
    protected long nextShot = 0L;
    public final String ENERGY_TAG = "Energy";
    public final String NEXT_USE_TAG = "NextUse";
    private final String COLOR_TAG = "LaserColor";
    protected ItemStack itemStackContainer;

    public ItemLaserThing() {
        this.func_77625_d(1);
    }

    public ItemLaserThing setEnergyParams(int maxEnergy, int maxTransfer, int energyPerShot) {
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        this.energyPerUse = energyPerShot;
        return this;
    }

    public ItemLaserThing getLaserThing(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemLaserThing) {
            return (ItemLaserThing)item;
        }
        return null;
    }

    public Color getColor(ItemStack stack) {
        return Color.color[NBTHelper.getInt(stack, "LaserColor")];
    }

    public int getColorID(ItemStack stack) {
        return NBTHelper.getInt(stack, "LaserColor");
    }

    public boolean canFire(ItemStack stack, World world) {
        ItemLaserThing laserThing = this.getLaserThing(stack);
        if (laserThing == null) {
            return false;
        }
        if (laserThing.getEnergyStored(stack) < laserThing.getEnergyPerUse(stack)) {
            return false;
        }
        return !(world.field_72995_K ? Minecraft.func_71386_F() < this.getNextShot(stack) : MinecraftServer.func_130071_aq() < this.getNextShot(stack));
    }

    public int getCoolDown() {
        return this.coolDown;
    }

    public void setCoolDown(int coolDown) {
        this.coolDown = coolDown;
    }

    public long getNextShot(ItemStack stack) {
        return NBTHelper.getLong(stack, "NextUse");
    }

    public void setCooldown(ItemStack stack, int coolDown) {
        ItemLaserThing laserThing = this.getLaserThing(stack);
        laserThing.setCoolDown(coolDown);
    }

    public int getCurrentCooldown(ItemStack stack) {
        return NBTHelper.getInt(stack, "NextUse");
    }

    public void setNextShot(ItemStack stack, World world) {
        if (world.field_72995_K) {
            NBTHelper.setLong(stack, "NextUse", Minecraft.func_71386_F() + (long)(this.getCoolDown() * 20));
        } else {
            NBTHelper.setLong(stack, "NextUse", MinecraftServer.func_130071_aq() + (long)(this.getCoolDown() * 20));
        }
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int i0, boolean b0) {
        super.func_77663_a(item, world, entity, i0, b0);
    }

    protected int useEnergy(ItemStack stack, boolean simulate) {
        return this.extractEnergy(stack, this.energyPerUse, simulate);
    }

    public int getEnergyPerUse(ItemStack stack) {
        return this.energyPerUse;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return this.maxEnergy - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return this.maxEnergy;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void func_77624_a(ItemStack var1, EntityPlayer var2, List var3, boolean var4);

    public boolean func_77630_h(ItemStack itemStack) {
        return false;
    }

    public Item setContainerItem(ItemStack stack) {
        this.itemStackContainer = stack;
        return this;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.itemStackContainer;
    }

    public boolean func_77634_r() {
        return true;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }
}

