/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.handler;

import com.gekox.gekosLasers.reference.ConfigSettings;
import com.gekox.gekosLasers.reference.LaserReference;
import com.gekox.gekosLasers.utility.LogHelper;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration config;

    public static void init(File configFile) {
        LogHelper.info("Reading config file");
        if (config == null) {
            config = new Configuration(configFile);
            LogHelper.info("Found the config");
            ConfigHandler.loadConfig();
        }
    }

    private static void loadConfig() {
        LogHelper.info("Loading config");
        ConfigSettings.LASERITE_OREGEN_CHANCE = config.getInt("LaseriteSpawnChance", "WorldGen", 15, 0, 100, "Chances to spawn per chunk. Set to 0 for no spawning");
        ConfigSettings.USE_TE_RECIPES = config.getBoolean("UseTERecipes", "Crafting", true, "If enabled, the mod will use Thermal Expansion -based recipes (if TE is also present)");
        ConfigSettings.LASER_SOUNDS = config.getFloat("LaserSounds", "general", 0.5f, 0.0f, 1.0f, "Volume level of lasers");
        ConfigSettings.EXPLOSIONS_RESPECT_GAMERULES = config.getBoolean("LasersRespectMobGriefing", "general", false, "Do explosive lasers respect MobGrifing?");
        ConfigSettings.RIFLE_COOLDOWN_MODIFER = config.getFloat("LaserRifleCoolDownModifer", "General Laser Settings", LaserReference.DEFAULT_RIFLE_COOLDOWN_MODIFER, 0.1f, 10.0f, "Value to modify the cooldown of all laser rifles by, eg: Teir1BaseCooldown * LaserRifleCoolDownModifer");
        ConfigSettings.RIFLE_DAMAGE_MODIFER = config.getFloat("LaserRifleDamageModifer", "General Laser Settings", LaserReference.DEFAULT_RIFLE_DAMAGE_MODIFER, 0.1f, 10.0f, "Value to modify the damage of all laser rifles by, eg: Teir1BaseDamage * LaserRifleDamageModifer");
        ConfigSettings.RIFLE_ENERGY_MODIFER = config.getFloat("LaserRifleEnergyModifer", "General Laser Settings", LaserReference.DEFAULT_RIFLE_ENERGY_MODIFER, 0.1f, 10.0f, "Value to modify the RF usage of all laser rifles by, eg: Teir1BaseEnergyUse * LaserRifleEnergyModifer");
        ConfigSettings.MINING_COOLDOWN_MODIFER = config.getFloat("PrecisionMiningLaserCoolDownModifer", "General Laser Settings", LaserReference.DEFAULT_MINING_COOLDOWN_MODIFER, 0.1f, 10.0f, "Value to modify the cooldown of all precision mining lasers by, eg: Teir1BaseCooldown * PrecisionMiningLaserCooldownModifer");
        ConfigSettings.MINING_DAMAGE_MODIFER = config.getFloat("PrecisionMiningLaserDamageModifer", "General Laser Settings", LaserReference.DEFAULT_MINING_DAMAGE_MODIFER, 0.1f, 10.0f, "Value to modify the damage of all precision mining lasers by, eg: Teir1BaseDamage * PrecisionMiningLaserDamageModifer");
        ConfigSettings.MINING_ENERGY_MODIFER = config.getFloat("PrecisionMiningLaserEnergyModifer", "General Laser Settings", LaserReference.DEFAULT_MINING_ENERGY_MODIFER, 0.1f, 10.0f, "Value to modify the RF usage of all precision mining lasers by, eg: Teir1BaseEnergyUse * PrecisionMiningLaserEnergyModifer");
        ConfigSettings.WIDE_COOLDOWN_MODIFER = config.getFloat("WideMiningLaserCoolDownModifer", "General Laser Settings", LaserReference.DEFAULT_WIDE_COOLDOWN_MODIFER, 0.1f, 10.0f, "Value to modify the cooldown of all wide mining lasers by, eg: Teir1BaseCooldown * WideMiningLaserCooldownModifer");
        ConfigSettings.WIDE_DAMAGE_MODIFER = config.getFloat("WideMiningLaserDamageModifer", "General Laser Settings", LaserReference.DEFAULT_WIDE_DAMAGE_MODIFER, 0.1f, 10.0f, "Value to modify the damage of all wide mining lasers by, eg: Teir1BaseDamage * WideMiningLaserDamageModifer");
        ConfigSettings.WIDE_ENERGY_MODIFER = config.getFloat("WideMiningLaserEnergyModifer", "General Laser Settings", LaserReference.DEFAULT_WIDE_ENERGY_MODIFER, 0.1f, 10.0f, "Value to modify the RF usage of all wide mining lasers by, eg: Teir1BaseEnergyUse * WideMiningLaserEnergyModifer");
        ConfigSettings.EXPLOSIVE_COOLDOWN_MODIFER = config.getFloat("ExplosiveMiningLaserCoolDownModifer", "General Laser Settings", LaserReference.DEFAULT_EXPLOSIVE_COOLDOWN_MODIFER, 0.1f, 10.0f, "Value to modify the cooldown of all explosive mining lasers by, eg: Teir1BaseCooldown * ExplosiveMiningLaserCooldownModifer");
        ConfigSettings.EXPLOSIVE_DAMAGE_MODIFER = config.getFloat("ExplosiveMiningLaserDamageModifer", "General Laser Settings", LaserReference.DEFAULT_EXPLOSIVE_DAMAGE_MODIFER, 0.1f, 10.0f, "Value to modify the damage of all explosive mining lasers by, eg: Teir1BaseDamage * ExplosiveMiningLaserDamageModifer");
        ConfigSettings.EXPLOSIVE_ENERGY_MODIFER = config.getFloat("ExplosiveMiningLaserEnergyModifer", "General Laser Settings", LaserReference.DEFAULT_EXPLOSIVE_ENERGY_MODIFER, 0.1f, 10.0f, "Value to modify the RF usage of all explosive mining lasers by, eg: Teir1BaseEnergyUse * ExplosiveMiningLaserEnergyModifer");
        ConfigSettings.ENDER_COOLDOWN_MODIFER = config.getFloat("EnderLaserCoolDownModifer", "General Laser Settings", LaserReference.DEFAULT_ENDER_COOLDOWN_MODIFER, 0.1f, 10.0f, "Value to modify the cooldown of all ender lasers by, eg: Teir1BaseCooldown * EnderLaserCooldownModifer");
        ConfigSettings.ENDER_DAMAGE_MODIFER = config.getFloat("EnderLaserDamageModifer", "General Laser Settings", LaserReference.DEFAULT_ENDER_DAMAGE_MODIFER, 0.1f, 10.0f, "Value to modify the damage of all ender lasers by, eg: Teir1BaseDamage * EnderLaserDamageModifer");
        ConfigSettings.ENDER_ENERGY_MODIFER = config.getFloat("EnderLaserEnergyModifer", "General Laser Settings", LaserReference.DEFAULT_ENDER_ENERGY_MODIFER, 0.1f, 10.0f, "Value to modify the RF usage of all ender lasers by, eg: Teir1BaseEnergyUse * EnderLaserEnergyModifer");
        ConfigSettings.FIRE_COOLDOWN_MODIFER = config.getFloat("FireLaserCoolDownModifer", "General Laser Settings", LaserReference.DEFAULT_FIRE_COOLDOWN_MODIFER, 0.1f, 10.0f, "Value to modify the cooldown of all fire lasers by, eg: Teir1BaseCooldown * FireLaserCooldownModifer");
        ConfigSettings.FIRE_DAMAGE_MODIFER = config.getFloat("FireLaserDamageModifer", "General Laser Settings", LaserReference.DEFAULT_FIRE_DAMAGE_MODIFER, 0.1f, 10.0f, "Value to modify the damage of all fire lasers by, eg: Teir1BaseDamage * FireLaserDamageModifer");
        ConfigSettings.FIRE_ENERGY_MODIFER = config.getFloat("FireLaserEnergyModifer", "General Laser Settings", LaserReference.DEFAULT_FIRE_ENERGY_MODIFER, 0.1f, 10.0f, "Value to modify the RF usage of all fire lasers by, eg: Teir1BaseEnergyUse * FireLaserEnergyModifer");
        ConfigSettings.SWORD_DAMAGE_MODIFER = config.getFloat("SwordDamageModifer", "General Laser Settings", LaserReference.DEFAULT_SWORD_DAMAGE_MODIFER, 0.1f, 10.0f, "Value to modify the damage of all swords by, eg: Teir1BaseDamage * SwordDamageModifer");
        ConfigSettings.SWORD_REFLECT_DAMAGE_MODIFER = config.getFloat("SwordReflectDamageModifer", "General Laser Settings", LaserReference.DEFAULT_SWORD_REFLECT_DAMAGE_MODIFER, 0.1f, 10.0f, "Value to modify the damage of all lasers reflected by a sword");
        ConfigSettings.TIER_1_MAX_ENERGY = config.getInt("Teir1MaxEnergy", "Tier 1 Laser Settings", LaserReference.DEFAULT_TIER_1_MAX_ENERGY, 1, 1000000, "How much RF this teir of laser holds");
        ConfigSettings.TIER_1_BASE_ENERGY_USE = config.getInt("Teir1BaseEnergyUse", "Tier 1 Laser Settings", LaserReference.DEFAULT_TIER_1_BASE_ENERGY_USE, 0, 100000, "Base RF use per shot");
        ConfigSettings.TIER_1_BASE_COOLDOWN = config.getInt("Teir1BaseCooldown", "Tier 1 Laser Settings", LaserReference.DEFAULT_TIER_1_BASE_COOLDOWN, 1, 10000, "Base number of ticks before this teir of laser can fire. 20 ticks = 1 second");
        ConfigSettings.TIER_1_BASE_DAMAGE = config.getInt("Teir1BaseDamage", "Tier 1 Laser Settings", LaserReference.DEFAULT_TIER_1_BASE_DAMAGE, 0, 100, "Base damage that all lasers in this teir do. 1 damage = 1/2 a heart");
        ConfigSettings.TIER_2_MAX_ENERGY = config.getInt("Teir2MaxEnergy", "Tier 2 Laser Settings", LaserReference.DEFAULT_TIER_2_MAX_ENERGY, 1, 1000000, "How much RF this teir of laser holds");
        ConfigSettings.TIER_2_BASE_ENERGY_USE = config.getInt("Teir2BaseEnergyUse", "Tier 2 Laser Settings", LaserReference.DEFAULT_TIER_2_BASE_ENERGY_USE, 0, 100000, "Base RF use per shot");
        ConfigSettings.TIER_2_BASE_COOLDOWN = config.getInt("Teir2BaseCooldown", "Tier 2 Laser Settings", LaserReference.DEFAULT_TIER_2_BASE_COOLDOWN, 1, 10000, "Base number of ticks before this teir of laser can fire. 20 ticks = 1 second");
        ConfigSettings.TIER_2_BASE_DAMAGE = config.getInt("Teir2BaseDamage", "Tier 2 Laser Settings", LaserReference.DEFAULT_TIER_2_BASE_DAMAGE, 0, 100, "Base damage that all lasers in this teir do. 1 damage = 1/2 a heart");
        ConfigSettings.TIER_3_MAX_ENERGY = config.getInt("Teir3MaxEnergy", "Tier 3 Laser Settings", LaserReference.DEFAULT_TIER_3_MAX_ENERGY, 1, 1000000, "How much RF this teir of laser holds");
        ConfigSettings.TIER_3_BASE_ENERGY_USE = config.getInt("Teir3BaseEnergyUse", "Tier 3 Laser Settings", LaserReference.DEFAULT_TIER_3_BASE_ENERGY_USE, 0, 100000, "Base RF use per shot");
        ConfigSettings.TIER_3_BASE_COOLDOWN = config.getInt("Teir3BaseCooldown", "Tier 3 Laser Settings", LaserReference.DEFAULT_TIER_3_BASE_COOLDOWN, 1, 10000, "Base number of ticks before this teir of laser can fire. 20 ticks = 1 second");
        ConfigSettings.TIER_3_BASE_DAMAGE = config.getInt("Teir3BaseDamage", "Tier 3 Laser Settings", LaserReference.DEFAULT_TIER_3_BASE_DAMAGE, 0, 100, "Base damage that all lasers in this teir do. 1 damage = 1/2 a heart");
        ConfigSettings.TIER_4_MAX_ENERGY = config.getInt("Teir4MaxEnergy", "Tier 4 Laser Settings", LaserReference.DEFAULT_TIER_4_MAX_ENERGY, 1, 1000000, "How much RF this teir of laser holds");
        ConfigSettings.TIER_4_BASE_ENERGY_USE = config.getInt("Teir4BaseEnergyUse", "Tier 4 Laser Settings", LaserReference.DEFAULT_TIER_4_BASE_ENERGY_USE, 0, 100000, "Base RF use per shot");
        ConfigSettings.TIER_4_BASE_COOLDOWN = config.getInt("Teir4BaseCooldown", "Tier 4 Laser Settings", LaserReference.DEFAULT_TIER_4_BASE_COOLDOWN, 1, 10000, "Base number of ticks before this teir of laser can fire. 20 ticks = 1 second");
        ConfigSettings.TIER_4_BASE_DAMAGE = config.getInt("Teir4BaseDamage", "Tier 4 Laser Settings", LaserReference.DEFAULT_TIER_4_BASE_DAMAGE, 0, 100, "Base damage that all lasers in this teir do. 1 damage = 1/2 a heart");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.modID.equalsIgnoreCase("GekosLasers")) {
            ConfigHandler.loadConfig();
        }
    }
}

