/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.entity.projectile.laser;

import cofh.api.energy.IEnergyReceiver;
import com.gekox.gekosLasers.init.ModBlocks;
import com.gekox.gekosLasers.items.ItemLaserSword;
import com.gekox.gekosLasers.reference.ConfigSettings;
import com.gekox.gekosLasers.reference.Reference;
import com.gekox.gekosLasers.utility.Color;
import com.gekox.gekosLasers.utility.LaserDamageSource;
import com.gekox.gekosLasers.utility.LaserUtils;
import com.gekox.gekosLasers.utility.LogHelper;
import com.gekox.gekosLasers.utility.NBTHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.world.BlockEvent;

public abstract class ProjectileLaser
extends EntityThrowable {
    private float speed = 1.0f;
    private float yaw;
    private float pitch;
    public int strength = 4;
    private int damage = 10;
    private int lifeTime = 0;
    public int maxLifeTime = 50;
    private String lifeTimeTag = "LIFETIME";
    public int blockBreakRadius = 1;
    public float explosionSize = 1.0f;
    public boolean doExplosionDamage = false;
    public boolean doFireDamage = false;
    public boolean doTeleport = false;
    public int burnTime = 2;
    public int transparencyPassThrough = 254;
    public int numOfThingsBroken = 0;
    public Block[] dontBreakBlocks = new Block[]{ModBlocks.crystalBlockLit, ModBlocks.crystalBlockUnlit, ModBlocks.redstoneCrystalBlockLit, ModBlocks.redstoneCrystalBlockUnlit};
    private Color color = Color.WHITE;
    protected boolean isWorkLaser = true;
    protected int attachedPower = 200;
    protected ItemStack attachedItemStack;
    private int lastX;
    private int lastY;
    private int lastZ;

    public ProjectileLaser(World world) {
        super(world);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.speed, 0.0f);
    }

    public ProjectileLaser(World world, Color c) {
        super(world);
        this.color = c;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.speed, 0.0f);
    }

    public ProjectileLaser(World world, EntityLivingBase entityBase, Color c) {
        super(world, entityBase);
        this.color = c;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.speed, 0.0f);
    }

    public ProjectileLaser setupLaser(int damage, int strength, int radius, boolean doExpl, float explSize, boolean doFire, int fireTime, boolean doTeleport) {
        this.damage = damage;
        this.strength = strength;
        this.blockBreakRadius = radius;
        this.doExplosionDamage = doExpl;
        this.explosionSize = explSize;
        this.doFireDamage = doFire;
        this.burnTime = fireTime;
        this.doTeleport = doTeleport;
        return this;
    }

    public ProjectileLaser setupLaser(int damage, int strength, int radius, boolean doExpl, float explSize, boolean doFire, int fireTime) {
        this.damage = damage;
        this.strength = strength;
        this.blockBreakRadius = radius;
        this.doExplosionDamage = doExpl;
        this.explosionSize = explSize;
        this.doFireDamage = doFire;
        this.burnTime = fireTime;
        return this;
    }

    public ProjectileLaser setupLaser(int damage, int strength, int radius, boolean doExpl, float explSize) {
        this.setupLaser(damage, strength, radius, doExpl, explSize, false, 0);
        return this;
    }

    public ProjectileLaser setupLaser(int damage, int strength, int radius) {
        this.setupLaser(damage, strength, radius, false, 0.0f, false, 0);
        return this;
    }

    public ProjectileLaser setupLaser(int damage, boolean doFire, int fireTime) {
        this.setupLaser(damage, fireTime, 1, false, 0.0f, doFire, fireTime);
        return this;
    }

    public ProjectileLaser setupLaser(int damage) {
        this.setupLaser(damage, -1, 1, false, 0.0f, false, 0);
        return this;
    }

    public ProjectileLaser setColor(Color color) {
        this.color = color;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public ProjectileLaser setLaserSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public void setExplosion(boolean doExpl) {
        this.doExplosionDamage = doExpl;
    }

    public void setExplosion(boolean doExpl, float radius) {
        this.doExplosionDamage = doExpl;
        this.explosionSize = radius;
    }

    public void setFire(boolean doFire) {
        this.doFireDamage = doFire;
    }

    public void setFire(boolean doFire, int time) {
        this.doFireDamage = doFire;
        this.burnTime = time;
    }

    public void setBlockBreakRadius(int amount) {
        this.blockBreakRadius = amount;
    }

    public ProjectileLaser setTeleport() {
        this.doTeleport = true;
        return this;
    }

    public ProjectileLaser attachPower(int power) {
        if (power > 0) {
            this.isWorkLaser = true;
            this.attachedPower = power;
        }
        return this;
    }

    public ProjectileLaser attachItemStack(ItemStack stack) {
        if (stack != null) {
            this.isWorkLaser = true;
            this.attachedItemStack = stack;
        }
        return this;
    }

    public boolean getIsWorkLaser() {
        return this.isWorkLaser;
    }

    public int getAttachedPower() {
        return this.attachedPower;
    }

    public ItemStack getAttachedItemStack() {
        return this.attachedItemStack;
    }

    public void func_70184_a(MovingObjectPosition movingObjPos) {
        Entity entity;
        if (this.field_70173_aa <= 1) {
            return;
        }
        int bX = movingObjPos.field_72311_b;
        int bY = movingObjPos.field_72312_c;
        int bZ = movingObjPos.field_72309_d;
        World world = this.field_70170_p;
        int side = movingObjPos.field_72310_e;
        boolean canKill = true;
        if (movingObjPos.field_72308_g != null && (entity = movingObjPos.field_72308_g) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (entity != null && entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).func_71045_bC() != null && ((EntityPlayerMP)entity).func_71045_bC().func_77973_b() instanceof ItemLaserSword && ((ItemLaserSword)((EntityPlayerMP)entity).func_71045_bC().func_77973_b()).getIsActive(((EntityPlayerMP)entity).func_71045_bC()) && ((EntityPlayerMP)entity).func_70632_aY()) {
                LogHelper.debug("Reflecting");
                ItemStack stack = ((EntityPlayerMP)entity).func_71045_bC();
                ItemLaserSword sword = (ItemLaserSword)stack.func_77973_b();
                Color color = Color.color[NBTHelper.getInt(stack, "LaserColor")];
                ProjectileLaser laser = LaserUtils.determineLaser(this.field_70170_p, (EntityPlayer)entity, color);
                laser.setupLaser((int)((float)this.damage * ConfigSettings.SWORD_REFLECT_DAMAGE_MODIFER), this.strength, this.blockBreakRadius, this.doExplosionDamage, this.explosionSize, this.doFireDamage, this.burnTime);
                laser.numOfThingsBroken = this.numOfThingsBroken;
                Random random = new Random();
                float varianceX = random.nextFloat() * 1.0f;
                float varianceY = random.nextFloat() * 1.0f;
                varianceY *= random.nextBoolean() ? 1.0f : -1.0f;
                float varianceZ = random.nextFloat() * 1.0f;
                varianceZ *= random.nextBoolean() ? 1.0f : -1.0f;
                laser.field_70159_w += (double)(varianceX *= random.nextBoolean() ? 1.0f : -1.0f);
                laser.field_70181_x += (double)varianceX;
                laser.field_70179_y += (double)varianceX;
                laser.func_70186_c(laser.field_70159_w, laser.field_70181_x, laser.field_70179_y, laser.speed, 0.0f);
                this.field_70170_p.func_72838_d((Entity)laser);
                this.field_70170_p.func_72956_a(entity, Reference.RESOURCE_PREFIX + "laser.pew", 0.5f, 1.0f);
                this.func_70106_y();
            } else {
                LaserDamageSource ds = new LaserDamageSource((Entity)this, (Entity)this.func_85052_h());
                entityliving.func_70097_a((DamageSource)ds, this.getDamage());
                if (this.doFireDamage) {
                    entity.func_70015_d(this.burnTime);
                }
                if (this.doExplosionDamage) {
                    world.func_72885_a((Entity)this, (double)bX, (double)bY, (double)bZ, this.explosionSize, false, ConfigSettings.EXPLOSIONS_RESPECT_GAMERULES ? this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") : true);
                }
                --this.numOfThingsBroken;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (bX == this.lastX && bY == this.lastY && bZ == this.lastZ) {
                return;
            }
            this.lastX = bX;
            this.lastY = bY;
            this.lastZ = bZ;
            if (movingObjPos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                EntityPlayerMP player;
                Block hitBlock = world.func_147439_a(bX, bY, bZ);
                hitBlock.func_149670_a(this.field_70170_p, bX, bY, bZ, (Entity)this);
                if (this.doTeleport && this.func_85052_h() != null && this.func_85052_h() instanceof EntityPlayerMP) {
                    EnderTeleportEvent event;
                    player = (EntityPlayerMP)this.func_85052_h();
                    if (player.field_71135_a.func_147362_b().func_150724_d() && player.field_70170_p == this.field_70170_p && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)player, (double)bX, (double)(bY + 1), (double)bZ, 2.0f)))) {
                        if (this.func_85052_h().func_70115_ae()) {
                            this.func_85052_h().func_70078_a((Entity)null);
                        }
                        this.func_85052_h().func_70634_a(event.targetX, event.targetY, event.targetZ);
                        this.func_85052_h().field_70143_R = 0.0f;
                        this.func_85052_h().func_70097_a(DamageSource.field_76379_h, event.attackDamage);
                    }
                }
                if (this.isWorkLaser && (world.func_147438_o(bX, bY, bZ) instanceof IInventory || world.func_147438_o(bX, bY, bZ) instanceof IEnergyReceiver)) {
                    IInventory te;
                    if (world.func_147438_o(bX, bY, bZ) instanceof IInventory && this.getAttachedItemStack() != null) {
                        te = (IInventory)world.func_147438_o(bX, bY, bZ);
                        ItemStack thisStack = this.getAttachedItemStack();
                        block5: for (int s = 0; s < te.func_70302_i_(); ++s) {
                            ItemStack stack = te.func_70301_a(s);
                            if (te.func_70301_a(s) == null) {
                                te.func_70299_a(s, this.getAttachedItemStack());
                                this.attachItemStack(null);
                                break;
                            }
                            if (stack.func_77973_b() != thisStack.func_77973_b()) continue;
                            for (int j = thisStack.field_77994_a; j > 0; --j) {
                                if (stack.field_77994_a >= stack.func_77976_d()) continue;
                                ++stack.field_77994_a;
                                --thisStack.field_77994_a;
                                if (thisStack.field_77994_a != 0) continue;
                                this.attachItemStack(null);
                                break block5;
                            }
                        }
                        if (thisStack.field_77994_a <= 0 || this.getAttachedItemStack() == null) {
                            this.setDead(true);
                        } else {
                            this.func_70106_y();
                        }
                    }
                    if (world.func_147438_o(bX, bY, bZ) instanceof IEnergyReceiver) {
                        te = (IEnergyReceiver)world.func_147438_o(bX, bY, bZ);
                        int powerToPass = Math.min(this.getAttachedPower() / Math.max(this.numOfThingsBroken, 1), te.getMaxEnergyStored(ForgeDirection.NORTH) - te.getEnergyStored(ForgeDirection.NORTH));
                        te.receiveEnergy(ForgeDirection.getOrientation((int)side), powerToPass, false);
                        this.attachedPower = Math.max(this.attachedPower - powerToPass, 0);
                        if (powerToPass > 0) {
                            --this.numOfThingsBroken;
                        }
                    }
                }
                for (Block b : this.dontBreakBlocks) {
                    if (b != hitBlock) continue;
                    this.numOfThingsBroken = -1;
                    this.func_70106_y();
                    return;
                }
                if (this.doFireDamage && this.func_85052_h() != null && this.func_85052_h() instanceof EntityPlayerMP) {
                    player = (EntityPlayerMP)this.func_85052_h();
                    this.setFire(this.field_70170_p, bX, bY, bZ, side);
                }
                if (this.numOfThingsBroken < 0) {
                    this.func_70106_y();
                }
                if (hitBlock.func_149717_k() > this.transparencyPassThrough && hitBlock.func_149662_c() && !hitBlock.isFoliage((IBlockAccess)world, bX, bY, bZ) && !hitBlock.hasTileEntity(hitBlock.func_149643_k(this.field_70170_p, bX, bY, bZ))) {
                    --this.numOfThingsBroken;
                }
                int xRange = this.blockBreakRadius;
                int yRange = this.blockBreakRadius;
                int zRange = 1;
                switch (side) {
                    case 0: 
                    case 1: {
                        yRange = 1;
                        zRange = this.blockBreakRadius;
                        break;
                    }
                    case 2: 
                    case 3: {
                        xRange = this.blockBreakRadius;
                        zRange = 1;
                        break;
                    }
                    case 4: 
                    case 5: {
                        xRange = 1;
                        zRange = this.blockBreakRadius;
                    }
                }
                for (int xPos = bX - xRange + 1; xPos <= bX + xRange - 1; ++xPos) {
                    for (int yPos = bY - yRange + 1; yPos <= bY + yRange - 1; ++yPos) {
                        for (int zPos = bZ - zRange + 1; zPos <= bZ + zRange - 1; ++zPos) {
                            Block block = world.func_147439_a(xPos, yPos, zPos);
                            int meta = world.func_72805_g(xPos, yPos, zPos);
                            boolean canHit = true;
                            if (block.func_149717_k() <= this.transparencyPassThrough) {
                                canHit = false;
                            }
                            if (!block.func_149662_c()) {
                                canHit = false;
                            }
                            if (block.isFoliage((IBlockAccess)world, bX, bY, bZ)) {
                                canHit = false;
                            }
                            if (world.func_147438_o(bX, bY, bZ) != null) {
                                canHit = false;
                            }
                            for (Block b : this.dontBreakBlocks) {
                                if (b != block) continue;
                                canHit = false;
                                break;
                            }
                            if (!canHit) continue;
                            if (this.doExplosionDamage) {
                                world.func_72885_a((Entity)this, (double)bX, (double)bY, (double)bZ, this.explosionSize, false, ConfigSettings.EXPLOSIONS_RESPECT_GAMERULES ? this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") : true);
                            }
                            if (this.doFireDamage) {
                                this.setFire(this.field_70170_p, xPos, yPos, zPos, side);
                                continue;
                            }
                            float blockHardness = block.func_149712_f(world, xPos, yPos, zPos);
                            LogHelper.debug("Block hardness: " + blockHardness);
                            if (blockHardness <= (float)this.strength) {
                                if (world.func_147439_a(xPos, yPos, zPos) == Blocks.field_150357_h || !(this.func_85052_h() instanceof EntityPlayerMP)) continue;
                                EntityPlayerMP player2 = (EntityPlayerMP)this.func_85052_h();
                                BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player2.field_71134_c.func_73081_b(), (EntityPlayerMP)player2, (int)xPos, (int)yPos, (int)zPos);
                                if (event.isCanceled() || !world.func_147468_f(xPos, yPos, zPos) || player2.field_71075_bZ.field_75098_d) continue;
                                block.func_149697_b(world, xPos, yPos, zPos, meta, 0);
                                continue;
                            }
                            this.numOfThingsBroken = -1;
                            this.func_70106_y();
                        }
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.numOfThingsBroken < 0) {
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public String toString() {
        return "LaserEntity @ " + this.field_70165_t + ", " + this.field_70163_u + ", " + this.field_70161_v;
    }

    public void func_70071_h_() {
        this.func_70037_a(this.getEntityData());
        ++this.lifeTime;
        if (this.lifeTime > this.maxLifeTime) {
            LogHelper.debug("Destroying laser projectile entity as it is too old");
            this.func_70106_y();
        }
        this.func_70014_b(this.getEntityData());
        super.func_70071_h_();
    }

    public void setDead(boolean destroyInven) {
        if (destroyInven) {
            this.attachedItemStack = null;
            this.attachedPower = 0;
        }
        this.func_70106_y();
    }

    public void func_70106_y() {
        if (this.attachedItemStack != null) {
            EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.attachedItemStack);
            this.field_70170_p.func_72838_d((Entity)item);
        }
        super.func_70106_y();
    }

    public int getHardness() {
        return this.strength;
    }

    public void setHardness(int h) {
        this.strength = h < 0 ? 0 : h;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(int d) {
        this.damage = d < 0 ? 0 : d;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a(this.lifeTimeTag, this.lifeTime);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b(this.lifeTimeTag)) {
            this.lifeTime = compound.func_74762_e(this.lifeTimeTag);
        }
    }

    private void setFire(World world, int x, int y, int z, int side) {
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        if (this.field_70170_p.func_147437_c(x, y, z)) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
        }
    }
}

