/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.blocks.tileEntity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.gekox.gekosLasers.GekosLasers;
import com.gekox.gekosLasers.blocks.tileEntity.TileEntityGL;
import com.gekox.gekosLasers.entity.projectile.laser.ProjectileLaser;
import com.gekox.gekosLasers.items.ItemLaserGun;
import com.gekox.gekosLasers.network.UpdateEnergyMessage;
import com.gekox.gekosLasers.reference.Reference;
import com.gekox.gekosLasers.utility.Color;
import com.gekox.gekosLasers.utility.LaserUtils;
import com.gekox.gekosLasers.utility.LogHelper;
import com.gekox.gekosLasers.utility.TurretUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTurret
extends TileEntityGL
implements IEnergyHandler,
IInventory {
    private ItemLaserGun laserThing;
    private int storageAmount = 200000;
    public EnergyStorage storage = new EnergyStorage(this.storageAmount);
    protected ItemStack[] inventory;
    protected List<String> trustedPlayers = new ArrayList<String>();
    protected final int coolDown = 20;
    protected int currentCooldown = 0;
    protected int energyPerUse = 200;
    protected int energyPerTick = 5;
    private ProjectileLaser laser;
    private Entity target;
    public boolean attackMobs;
    public boolean attackPlayers;
    public int range = 14;
    private int accuracyMod = 10;
    private int damageMod = 10;
    private int cooldownMod = 10;
    public boolean isActive = false;
    private final String TAG_MAX_ENERGY = "maxEnergy";
    private final String TAG_STORED_ENERGY = "storedEnergy";
    private final String TAG_MAX_IO = "maxIO";
    private final String TAG_INVENTORY = "inventory";
    private final String TAG_COOLDOWN = "cooldown";
    private final String TAG_ATTACK_MOBS = "attackMobs";
    private final String TAG_ATTACK_PLAYERS = "attackPlayers";
    private final String TAG_ACCURACY_MOD = "accuracyMod";
    private final String TAG_DAMAGE_MOD = "damageMod";
    private final String TAG_COOLDOWN_MOD = "cooldownMod";
    private final String TAG_RANGE = "range";

    public TileEntityTurret() {
        this.inventory = new ItemStack[1];
    }

    public boolean isGettingRedstoneSignal() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74762_e(this.TAG_MAX_ENERGY));
        this.storage.setEnergyStored(nbt.func_74762_e(this.TAG_STORED_ENERGY));
        this.storage.setMaxReceive(nbt.func_74762_e(this.TAG_MAX_IO));
        this.currentCooldown = nbt.func_74762_e(this.TAG_COOLDOWN);
        this.attackMobs = nbt.func_74767_n("attackMobs");
        this.attackPlayers = nbt.func_74767_n("attackPlayers");
        this.damageMod = nbt.func_74762_e("damageMod");
        this.accuracyMod = nbt.func_74762_e("accuracyMod");
        this.cooldownMod = nbt.func_74762_e("cooldownMod");
        this.range = nbt.func_74762_e("range");
        NBTTagList tagList = nbt.func_150295_c(this.TAG_INVENTORY, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a(this.TAG_MAX_ENERGY, this.storage.getMaxEnergyStored());
        nbt.func_74768_a(this.TAG_STORED_ENERGY, this.getEnergyStored());
        nbt.func_74768_a(this.TAG_MAX_IO, this.storage.getMaxReceive());
        nbt.func_74768_a("cooldown", this.currentCooldown);
        nbt.func_74757_a("attackMobs", this.attackMobs);
        nbt.func_74757_a("attackPlayers", this.attackPlayers);
        nbt.func_74768_a("damageMod", this.damageMod);
        nbt.func_74768_a("accuracyMod", this.accuracyMod);
        nbt.func_74768_a("cooldownMod", this.cooldownMod);
        nbt.func_74768_a("range", this.range);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a(this.TAG_INVENTORY, (NBTBase)itemList);
    }

    public void addTrustedPlayer(String name) {
        this.trustedPlayers.add(name);
    }

    public void removeTrustedPlayer(String name) {
        this.trustedPlayers.remove(name);
    }

    public List<String> getTrustedPlayers() {
        return this.trustedPlayers;
    }

    private NBTTagList getTrustedPlayersAsNBT() {
        NBTTagList nbt = new NBTTagList();
        for (String trustedPlayer : this.trustedPlayers) {
            nbt.func_74742_a((NBTBase)new NBTTagString(trustedPlayer));
        }
        return nbt;
    }

    public int getBaseEnergyPerTick() {
        return this.energyPerTick;
    }

    public int getEnergyPerTick() {
        return TurretUtil.getRFUsePerTick(this.energyPerTick, this.range);
    }

    public int getBaseEnergyPerShot() {
        return this.energyPerUse;
    }

    public int getEnergyPerShot() {
        return TurretUtil.getRFUsePerShot(this.energyPerUse, this.damageMod, this.accuracyMod, this.cooldownMod);
    }

    private List<String> buildTrustedPlayersFromNBT(NBTTagList nbt) {
        ArrayList<String> trusted_players = new ArrayList<String>();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            trusted_players.add(nbt.func_150307_f(i));
        }
        return trusted_players;
    }

    public EnergyStorage getStorage() {
        return this.storage;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isGettingRedstoneSignal()) {
            this.extractEnergy(ForgeDirection.DOWN, this.getEnergyPerTick(), false);
        }
        boolean bl = this.isActive = this.getEnergyStored() > 0;
        if (this.currentCooldown > 0) {
            --this.currentCooldown;
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof ItemLaserGun) {
            ItemStack stack = this.inventory[0];
            ItemLaserGun gun = (ItemLaserGun)stack.func_77973_b();
            if (gun.getCurrentCooldown(stack) > 0) {
                gun.setCooldown(stack, gun.getCurrentCooldown(stack) - 1);
            }
            if (this.getEnergyStored() > 0 && gun.getEnergyStored(stack) < gun.getMaxEnergyStored(stack)) {
                gun.receiveEnergy(stack, gun.maxTransfer, false);
                this.extractEnergy(ForgeDirection.DOWN, gun.maxTransfer, false);
            }
            if (!this.isGettingRedstoneSignal() && this.getEnergyStored() > this.getEnergyPerShot()) {
                this.fire(gun, stack);
            }
        }
        UpdateEnergyMessage energyMessage = new UpdateEnergyMessage(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getEnergyStored());
        GekosLasers.network.sendToAll((IMessage)energyMessage);
    }

    private void fire(ItemLaserGun gun, ItemStack stack) {
        if (this.currentCooldown > 0) {
            return;
        }
        this.target = this.getTarget();
        if (this.target == null) {
            return;
        }
        LogHelper.debug("Firing turret: " + ((Object)((Object)this)).toString());
        double d0 = this.target.field_70165_t - (double)this.field_145851_c - 0.5;
        double d1 = this.target.field_70163_u + (double)this.target.func_70047_e() - (double)(this.field_145848_d + 1);
        double d2 = this.target.field_70161_v - (double)this.field_145849_e - 0.5;
        this.laser = LaserUtils.determineLaser(this.func_145831_w(), Color.color[gun.getColorID(stack)]);
        this.laser.setupLaser((int)Math.max((float)gun.getLaserDamage() * ((float)this.getDamageMod() / 10.0f), 1.0f), gun.getLaserStrength(), gun.getLaserBlockBreakRadius(), gun.isLaserDoExplosionDamage(), gun.getLaserExplosionSize(), gun.isLaserDoFireDamage(), gun.getLaserBurnTime(), gun.isLaserDoTeleport());
        this.laser.numOfThingsBroken = gun.getNumOfThingsBroken();
        this.laser.func_70186_c(d0 + this.target.field_70159_w, d1 + this.target.field_70181_x, d2 + this.target.field_70179_y, 1.0f, 2.0f - (float)this.getAccuracyMod() / 10.0f);
        this.laser.func_70107_b((double)this.field_145851_c + 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.5);
        this.field_145850_b.func_72838_d((Entity)this.laser);
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, Reference.RESOURCE_PREFIX + "laser.pew", 0.5f, 1.0f);
        this.currentCooldown = (int)((float)gun.getCoolDown() * 1.5f / ((float)this.getCooldownMod() / 10.0f));
        gun.extractEnergy(stack, gun.energyPerUse, false);
        this.extractEnergy(ForgeDirection.DOWN, this.getEnergyPerShot(), false);
    }

    public void changeTarget(int target) {
        switch (target) {
            case 0: {
                this.attackMobs = false;
                this.attackPlayers = false;
                break;
            }
            case 1: {
                this.attackMobs = true;
                this.attackPlayers = false;
                break;
            }
            case 2: {
                this.attackMobs = false;
                this.attackPlayers = true;
                break;
            }
            case 3: {
                this.attackMobs = true;
                this.attackPlayers = true;
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
        this.target = this.getTarget();
        LogHelper.info("ChangingTarget - Got a value of " + target);
        LogHelper.info("Setting Mobs to " + this.attackMobs + " and Players to " + this.attackPlayers);
    }

    public int getTargetValue() {
        int val = 0;
        if (!this.attackMobs && !this.attackPlayers) {
            val = 0;
        }
        if (this.attackMobs && !this.attackPlayers) {
            val = 1;
        }
        if (!this.attackMobs && this.attackPlayers) {
            val = 2;
        }
        if (this.attackMobs && this.attackPlayers) {
            val = 3;
        }
        LogHelper.info("GetTargetValue - M: " + this.attackMobs + " P: " + this.attackPlayers);
        LogHelper.info("ID generated: " + val);
        return val;
    }

    private Entity getTarget() {
        return TurretUtil.getTarget(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.range);
    }

    public int getAccuracyMod() {
        return this.accuracyMod;
    }

    public void setAccuracyMod(int accuracyMod) {
        this.accuracyMod = accuracyMod;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public int getDamageMod() {
        return this.damageMod;
    }

    public void setDamageMod(int damageMod) {
        this.damageMod = damageMod;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public int getCooldownMod() {
        return this.cooldownMod;
    }

    public void setCooldownMod(int cooldownMod) {
        this.cooldownMod = cooldownMod;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int getEnergyStored() {
        return this.getEnergyStored(ForgeDirection.DOWN);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(ForgeDirection.DOWN);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.hasOwner() ? this.getOwner() + "'s Laserite Turret" : "Unowned Laserite Turret";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemLaserGun;
    }
}

